/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPortChecker {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(LocalPortChecker.class);
    public static final int MAX_PORT = 65535;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isPortAvailable(int port) {
        Preconditions.checkArgument((boolean)LocalPortChecker.isPortFromOneToMaxInclusive(port), (String)"Invalid port: %s", (int)port);
        try (ServerSocket serverSocket = new ServerSocket(port);){
            DatagramSocket dataSocket = new DatagramSocket(port);
            try {
                serverSocket.setReuseAddress(true);
                dataSocket.setReuseAddress(true);
                boolean bl = true;
                dataSocket.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    dataSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.trace("Error occurred checking port availability for port {}", (Object)port, (Object)e);
            return false;
        }
    }

    public OptionalInt findFirstOpenPortFrom(int port) {
        LocalPortChecker.checkPortOneToMaxPortInclusive(port);
        int startPort = port - 1;
        return this.findFirstOpenPortAbove(startPort);
    }

    public OptionalInt findFirstOpenPortAbove(int port) {
        LocalPortChecker.checkPortZeroInclusiveToMaxPortExclusive(port);
        return IntStream.rangeClosed(port + 1, 65535).filter(this::isPortAvailable).findFirst();
    }

    public OptionalInt findRandomOpenPort() {
        return this.findRandomOpenPortAbove(0);
    }

    public OptionalInt findRandomOpenPortFrom(int port) {
        LocalPortChecker.checkPortOneToMaxPortInclusive(port);
        int startPort = port - 1;
        return this.findRandomOpenPortAbove(startPort);
    }

    private static void checkPortOneToMaxPortInclusive(int port) {
        Preconditions.checkArgument((boolean)LocalPortChecker.isPortFromOneToMaxInclusive(port), (String)"Invalid start port: %s", (int)port);
    }

    private static boolean isPortFromOneToMaxInclusive(int port) {
        return port > 0 && port <= 65535;
    }

    public OptionalInt findRandomOpenPortAbove(int port) {
        LocalPortChecker.checkPortZeroInclusiveToMaxPortExclusive(port);
        int minPort = port + 1;
        int maxPortBound = 65536;
        return IntStream.generate(() -> ThreadLocalRandom.current().nextInt(minPort, maxPortBound)).filter(this::isPortAvailable).limit(100L).findFirst();
    }

    private static void checkPortZeroInclusiveToMaxPortExclusive(int port) {
        Preconditions.checkArgument((port >= 0 && port < 65535 ? 1 : 0) != 0, (String)"Invalid start port: %s", (int)port);
    }
}

