/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChecker {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(SocketChecker.class);
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);

    public boolean canConnectViaSocket(String host, int port) {
        return this.canConnectViaSocket(host, port, DEFAULT_TIMEOUT);
    }

    public boolean canConnectViaSocket(String host, int port, Duration timeout) {
        boolean bl;
        Socket socket = new Socket();
        try {
            LOG.trace("Checking socket at {}:{} with timeout {} ms", new Object[]{host, port, timeout.toMillis()});
            socket.connect(new InetSocketAddress(host, port), Ints.checkedCast((long)timeout.toMillis()));
            LOG.trace("Socket at {}:{} is available", (Object)host, (Object)port);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.trace("Socket at {}:{} not available", new Object[]{host, port, e});
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public boolean canConnectViaSocket(Pair<String, Integer> hostAndPort) {
        return this.canConnectViaSocket(hostAndPort, DEFAULT_TIMEOUT);
    }

    public boolean canConnectViaSocket(Pair<String, Integer> hostAndPort, Duration timeout) {
        String host = (String)hostAndPort.getLeft();
        Integer port = (Integer)hostAndPort.getRight();
        return this.canConnectViaSocket(host, port, timeout);
    }
}

