/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.OptionalInt;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.retry.Attempt;
import org.kiwiproject.retry.RetryException;

public class KiwiRetryerException
extends RuntimeException {
    public KiwiRetryerException(String message, Exception cause) {
        super(message, KiwiRetryerException.requireValidCause(cause));
    }

    private static Exception requireValidCause(Exception cause) {
        KiwiPreconditions.checkArgumentNotNull(cause, "cause is required");
        Preconditions.checkArgument((cause instanceof RetryException || cause instanceof InterruptedException ? 1 : 0) != 0, (String)"cause must be a RetryException or an InterruptedException but was a %s", (Object)cause.getClass().getName());
        return cause;
    }

    public static Optional<Throwable> unwrapKiwiRetryerException(KiwiRetryerException kiwiRetryerEx) {
        Throwable cause = kiwiRetryerEx.getCause();
        return Optional.of(cause);
    }

    public static Optional<Throwable> unwrapKiwiRetryerExceptionFully(KiwiRetryerException kiwiRetryerEx) {
        Throwable throwable = KiwiRetryerException.unwrapKiwiRetryerException(kiwiRetryerEx).orElse(null);
        if (throwable instanceof RetryException) {
            return Optional.ofNullable(throwable.getCause());
        }
        return Optional.ofNullable(throwable);
    }

    public Optional<Throwable> unwrap() {
        return KiwiRetryerException.unwrapKiwiRetryerException(this);
    }

    public Optional<Throwable> unwrapFully() {
        return KiwiRetryerException.unwrapKiwiRetryerExceptionFully(this);
    }

    public boolean isCauseRetryException() {
        return this.getCause() instanceof RetryException;
    }

    public boolean isCauseInterruptedException() {
        return this.getCause() instanceof InterruptedException;
    }

    public Optional<Attempt<?>> getLastAttempt() {
        return this.unwrapAsRetryException().map(RetryException::getLastFailedAttempt);
    }

    public OptionalInt getNumberOfFailedAttempts() {
        return this.unwrapAsRetryException().stream().mapToInt(RetryException::getNumberOfFailedAttempts).findFirst();
    }

    public Optional<RetryException> unwrapAsRetryException() {
        return this.unwrap().filter(RetryException.class::isInstance).map(RetryException.class::cast);
    }
}

