/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.kiwiproject.base.DefaultEnvironment;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.retry.RetryLogger;
import org.kiwiproject.retry.RetryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class SimpleRetries {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRetries.class);
    private static final KiwiEnvironment DEFAULT_KIWI_ENV = new DefaultEnvironment();
    private static final String ATTEMPT_MSG_TEMPLATE = "Attempt {} of {} to obtain a(n) {} from supplier";

    public static <T> Optional<T> tryGetObject(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(maxAttempts, retryDelay, retryDelayUnit, DEFAULT_KIWI_ENV, supplier);
    }

    public static <T> Optional<T> tryGetObject(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(maxAttempts, retryDelay, retryDelayUnit, environment, "object", Level.TRACE, supplier);
    }

    public static <T> Optional<T> tryGetObject(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, Class<T> type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(maxAttempts, retryDelay, retryDelayUnit, DEFAULT_KIWI_ENV, type, supplier);
    }

    public static <T> Optional<T> tryGetObject(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, Class<T> type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(maxAttempts, retryDelay, retryDelayUnit, environment, type.getSimpleName(), Level.TRACE, supplier);
    }

    public static <T> Optional<T> tryGetObject(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Level level, Supplier<T> supplier) {
        return IntStream.rangeClosed(1, maxAttempts).mapToObj(SimpleRetries.objectOrNull(maxAttempts, retryDelay, retryDelayUnit, environment, type, level, supplier)).filter(Objects::nonNull).findFirst();
    }

    private static <T> IntFunction<T> objectOrNull(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Level level, Supplier<T> supplier) {
        return currentAttempt -> {
            RetryLogger.logAttempt(LOG, level, currentAttempt, ATTEMPT_MSG_TEMPLATE, currentAttempt, maxAttempts, type);
            Object object = SimpleRetries.safeGetOrNull(currentAttempt, maxAttempts, type, level, supplier);
            if (Objects.isNull(object) && currentAttempt < maxAttempts) {
                environment.sleepQuietly(retryDelay, retryDelayUnit);
            } else if (Objects.nonNull(object)) {
                SimpleRetries.traceLogResultReceived(currentAttempt, maxAttempts, type);
            }
            return object;
        };
    }

    private static <T> T safeGetOrNull(int currentAttempt, int maxAttempts, String type, Level level, Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            RetryLogger.logAttempt(LOG, level, "Error occurred on attempt {} of {} getting {} from supplier", currentAttempt, maxAttempts, type, e);
            return null;
        }
    }

    public static <T> RetryResult<T> tryGetObjectCollectingErrors(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(maxAttempts, retryDelay, retryDelayUnit, DEFAULT_KIWI_ENV, "object", supplier);
    }

    public static <T> RetryResult<T> tryGetObjectCollectingErrors(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, Class<T> type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(maxAttempts, retryDelay, retryDelayUnit, DEFAULT_KIWI_ENV, type, supplier);
    }

    public static <T> RetryResult<T> tryGetObjectCollectingErrors(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, Class<T> type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(maxAttempts, retryDelay, retryDelayUnit, environment, type.getSimpleName(), supplier);
    }

    public static <T> RetryResult<T> tryGetObjectCollectingErrors(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(maxAttempts, retryDelay, retryDelayUnit, environment, type, Level.TRACE, supplier);
    }

    public static <T> RetryResult<T> tryGetObjectCollectingErrors(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Level level, Supplier<T> supplier) {
        List<Pair<T, Exception>> results = SimpleRetries.collectResults(maxAttempts, retryDelay, retryDelayUnit, environment, type, level, supplier);
        int numAttemptsMade = results.size();
        Object object = results.stream().filter(pair -> Objects.nonNull(pair.getLeft())).map(Pair::getLeft).findFirst().orElse(null);
        List<Exception> errors = results.stream().filter(pair -> Objects.nonNull(pair.getRight())).map(Pair::getRight).toList();
        return new RetryResult<Object>(numAttemptsMade, maxAttempts, object, errors);
    }

    private static <T> List<Pair<T, Exception>> collectResults(int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Level level, Supplier<T> supplier) {
        ArrayList<Pair<T, Exception>> results = new ArrayList<Pair<T, Exception>>();
        for (int currentAttempt = 1; currentAttempt <= maxAttempts; ++currentAttempt) {
            Pair<T, Exception> resultOrError = SimpleRetries.resultOrErrorPair(currentAttempt, maxAttempts, retryDelay, retryDelayUnit, environment, type, level, supplier);
            results.add(resultOrError);
            if (!Objects.nonNull(resultOrError.getLeft())) continue;
            SimpleRetries.traceLogResultReceived(currentAttempt, maxAttempts, type);
            break;
        }
        return results;
    }

    private static <T> Pair<T, Exception> resultOrErrorPair(int currentAttempt, int maxAttempts, long retryDelay, TimeUnit retryDelayUnit, KiwiEnvironment environment, String type, Level level, Supplier<T> supplier) {
        RetryLogger.logAttempt(LOG, level, currentAttempt, ATTEMPT_MSG_TEMPLATE, currentAttempt, maxAttempts, type);
        Object object = null;
        Exception error = null;
        try {
            object = supplier.get();
        }
        catch (Exception e) {
            error = e;
        }
        if (Objects.isNull(object) && currentAttempt < maxAttempts) {
            environment.sleepQuietly(retryDelay, retryDelayUnit);
        }
        return Pair.of(object, (Object)error);
    }

    private static void traceLogResultReceived(int currentAttempt, int maxAttempts, String type) {
        LOG.trace("Received a result on attempt {} of {} to get {}; no more attempts are needed", new Object[]{currentAttempt, maxAttempts, type});
    }

    @Generated
    private SimpleRetries() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

