/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.security;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.KiwiSecurity;

public interface TrustStoreConfigProvider {
    public String getProtocol();

    public String getTrustStorePath();

    public String getTrustStorePassword();

    default public String getTrustStoreType() {
        return KeyStoreType.JKS.value;
    }

    default public boolean isVerifyHostname() {
        return true;
    }

    default public SSLContext toSSLContext() {
        return KiwiSecurity.createSslContext(null, null, null, this.getTrustStorePath(), this.getTrustStorePassword(), this.getTrustStoreType(), this.getProtocol());
    }

    default public SSLSocketFactory toSslSocketFactory() {
        return this.toSSLContext().getSocketFactory();
    }
}

