/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringContextBuilder {
    private final Map<String, Object> parentContextBeans = new LinkedHashMap<String, Object>();
    private final List<Class<?>> annotatedClasses = new ArrayList();
    private final List<String> configLocations = new ArrayList<String>();

    public SpringContextBuilder addParentContextBean(String name, Object bean) {
        this.parentContextBeans.put(name, bean);
        return this;
    }

    public SpringContextBuilder addAnnotationConfiguration(Class<?> aClass) {
        this.checkConfigLocationsIsEmpty();
        this.annotatedClasses.add(aClass);
        return this;
    }

    public SpringContextBuilder withAnnotationConfigurations(Class<?> ... classes) {
        this.checkConfigLocationsIsEmpty();
        Collections.addAll(this.annotatedClasses, classes);
        return this;
    }

    private void checkConfigLocationsIsEmpty() {
        Preconditions.checkState((boolean)this.configLocations.isEmpty(), (Object)"XML config locations have already been specified - annotated classes cannot be added!");
    }

    public SpringContextBuilder addXmlConfigLocation(String location) {
        this.checkAnnotatedClassesIsEmpty();
        this.configLocations.add(location);
        return this;
    }

    public SpringContextBuilder withXmlConfigLocations(String ... locations) {
        this.checkAnnotatedClassesIsEmpty();
        Collections.addAll(this.configLocations, locations);
        return this;
    }

    private void checkAnnotatedClassesIsEmpty() {
        Preconditions.checkState((boolean)this.annotatedClasses.isEmpty(), (Object)"Annotated classes have already been specified - XML config locations cannot be added!");
    }

    public ApplicationContext build() {
        ApplicationContext parent = this.buildParentApplicationContext();
        return this.buildContext(parent);
    }

    private ApplicationContext buildParentApplicationContext() {
        AnnotationConfigApplicationContext parent = new AnnotationConfigApplicationContext();
        parent.refresh();
        ConfigurableListableBeanFactory beanFactory = parent.getBeanFactory();
        this.parentContextBeans.forEach((arg_0, arg_1) -> ((ConfigurableListableBeanFactory)beanFactory).registerSingleton(arg_0, arg_1));
        parent.registerShutdownHook();
        parent.start();
        return parent;
    }

    private ApplicationContext buildContext(ApplicationContext parent) {
        if (this.annotatedClasses.isEmpty()) {
            return this.buildXmlContext(parent);
        }
        return this.buildAnnotationContext(parent);
    }

    private ApplicationContext buildAnnotationContext(ApplicationContext parent) {
        AnnotationConfigApplicationContext annotationContext = new AnnotationConfigApplicationContext();
        annotationContext.setParent(parent);
        this.annotatedClasses.forEach(xva$0 -> annotationContext.register(new Class[]{xva$0}));
        annotationContext.refresh();
        annotationContext.registerShutdownHook();
        annotationContext.start();
        return annotationContext;
    }

    private ApplicationContext buildXmlContext(ApplicationContext parent) {
        ClassPathXmlApplicationContext xmlContext = new ClassPathXmlApplicationContext();
        xmlContext.setParent(parent);
        xmlContext.setConfigLocations(this.configLocations.toArray(new String[0]));
        xmlContext.refresh();
        xmlContext.registerShutdownHook();
        xmlContext.start();
        return xmlContext;
    }
}

