/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Objects;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.search.KiwiSearching;
import org.kiwiproject.spring.data.PagingParams;
import org.springframework.data.domain.Sort;

public class PagingRequest
implements PagingParams {
    public static final int DEFAULT_MAX_LIMIT = 100;
    @QueryParam(value="page")
    @DefaultValue(value="0")
    private Integer page = 0;
    @QueryParam(value="numbering")
    @DefaultValue(value="ZERO_BASED")
    private KiwiSearching.PageNumberingScheme numbering = KiwiSearching.PageNumberingScheme.ZERO_BASED;
    @QueryParam(value="limit")
    @DefaultValue(value="100")
    private Integer limit = 100;
    @QueryParam(value="primarySort")
    private String primarySort;
    @QueryParam(value="primaryDirection")
    @DefaultValue(value="ASC")
    private Sort.Direction primaryDirection = Sort.Direction.ASC;
    @QueryParam(value="secondarySort")
    private String secondarySort;
    @QueryParam(value="secondaryDirection")
    @DefaultValue(value="ASC")
    private Sort.Direction secondaryDirection = Sort.Direction.ASC;

    public static PagingRequest copyOf(PagingRequest original) {
        KiwiPreconditions.checkArgumentNotNull(original, "PagingRequest to copy must not be null");
        PagingRequest copy = new PagingRequest();
        copy.setPage(original.getPage());
        copy.setNumbering(original.getNumbering());
        copy.setLimit(original.getLimit());
        copy.setPrimarySort(original.getPrimarySort());
        copy.setPrimaryDirection(original.getPrimaryDirection());
        copy.setSecondarySort(original.getSecondarySort());
        copy.setSecondaryDirection(original.getSecondaryDirection());
        return copy;
    }

    public PagingRequest copyOf() {
        return PagingRequest.copyOf(this);
    }

    public static boolean ensurePaginationProperties(PagingRequest request) {
        boolean changed = false;
        Integer limit = request.getLimit();
        if (Objects.isNull(limit) || limit < 1) {
            request.setLimit(100);
            changed = true;
        }
        if (Objects.isNull((Object)request.getNumbering())) {
            request.setNumbering(KiwiSearching.PageNumberingScheme.ZERO_BASED);
            changed = true;
        }
        int minPage = request.getNumbering().getMinimumPageNumber();
        Integer page = request.getPage();
        if (Objects.isNull(page) || page < minPage) {
            request.setPage(minPage);
            changed = true;
        }
        return changed;
    }

    public static PagingRequest withPaginationProperties(PagingRequest request) {
        KiwiPreconditions.checkArgumentNotNull(request, "PagingRequest must not be null");
        if (request.hasPaginationProperties()) {
            return request;
        }
        PagingRequest newRequest = request.copyOf();
        PagingRequest.ensurePaginationProperties(newRequest);
        return newRequest;
    }

    public PagingRequest withPaginationProperties() {
        return PagingRequest.withPaginationProperties(this);
    }

    @Override
    @Generated
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Generated
    public KiwiSearching.PageNumberingScheme getNumbering() {
        return this.numbering;
    }

    @Override
    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    @Generated
    public String getPrimarySort() {
        return this.primarySort;
    }

    @Override
    @Generated
    public Sort.Direction getPrimaryDirection() {
        return this.primaryDirection;
    }

    @Override
    @Generated
    public String getSecondarySort() {
        return this.secondarySort;
    }

    @Override
    @Generated
    public Sort.Direction getSecondaryDirection() {
        return this.secondaryDirection;
    }

    @Override
    @Generated
    public void setPage(Integer page) {
        this.page = page;
    }

    @Override
    @Generated
    public void setNumbering(KiwiSearching.PageNumberingScheme numbering) {
        this.numbering = numbering;
    }

    @Override
    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    @Generated
    public void setPrimarySort(String primarySort) {
        this.primarySort = primarySort;
    }

    @Override
    @Generated
    public void setPrimaryDirection(Sort.Direction primaryDirection) {
        this.primaryDirection = primaryDirection;
    }

    @Override
    @Generated
    public void setSecondarySort(String secondarySort) {
        this.secondarySort = secondarySort;
    }

    @Override
    @Generated
    public void setSecondaryDirection(Sort.Direction secondaryDirection) {
        this.secondaryDirection = secondaryDirection;
    }

    @Generated
    public String toString() {
        return "PagingRequest(page=" + this.getPage() + ", numbering=" + this.getNumbering() + ", limit=" + this.getLimit() + ", primarySort=" + this.getPrimarySort() + ", primaryDirection=" + this.getPrimaryDirection() + ", secondarySort=" + this.getSecondarySort() + ", secondaryDirection=" + this.getSecondaryDirection() + ")";
    }
}

