/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.util.regex;

import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.kiwiproject.util.regex.MatcherSpliterator;
import org.kiwiproject.util.regex.NoMatchesFoundException;

public final class KiwiRegexes {
    public static String extractMatchOrNull(Pattern pattern, String input) {
        return KiwiRegexes.extractMatch(pattern, input).orElse(null);
    }

    public static String extractMatchOrThrow(Pattern pattern, String input) {
        return KiwiRegexes.extractMatch(pattern, input).orElseThrow(() -> NoMatchesFoundException.forPattern(pattern));
    }

    public static Optional<String> extractMatch(Pattern pattern, String input) {
        return KiwiRegexes.extractMatches(pattern, input).map(MatchResult::group).findFirst();
    }

    public static Stream<MatchResult> extractMatches(Pattern pattern, String input) {
        return StreamSupport.stream(new MatcherSpliterator(pattern.matcher(input)), false);
    }

    @Generated
    private KiwiRegexes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

