/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Preconditions;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.groups.Default;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiSets;
import org.kiwiproject.reflect.KiwiReflection;
import org.kiwiproject.validation.KiwiConstraintViolations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiValidations {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiValidations.class);
    private static Validator validatorInstance = KiwiValidations.newValidator();

    public static Validator newValidator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public static Validator getValidator() {
        return validatorInstance;
    }

    public static void setValidator(Validator newValidator) {
        LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        LOG.warn("               Overriding static Validator instance             !!!");
        LOG.warn("!!! You should only see this in tests or an application startup !!!");
        LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        validatorInstance = newValidator;
    }

    public static <T> Set<ConstraintViolation<T>> validate(T object) {
        return validatorInstance.validate(object, new Class[]{Default.class});
    }

    public static <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groupClasses) {
        return validatorInstance.validate(object, (Class[])groupClasses);
    }

    public static <T> void validateThrowing(T object) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object);
        KiwiValidations.throwConstraintViolationExceptionIfNotEmpty(violations);
    }

    public static <T> void validateThrowing(T object, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object, groupClasses);
        KiwiValidations.throwConstraintViolationExceptionIfNotEmpty(violations);
    }

    public static <T> void throwConstraintViolationExceptionIfNotEmpty(Set<ConstraintViolation<T>> violations) {
        if (KiwiSets.isNotNullOrEmpty(violations)) {
            throw new ConstraintViolationException(violations);
        }
    }

    public static <T> void checkArgumentValid(T object) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object);
        KiwiValidations.checkArgumentNoViolations(violations);
    }

    public static <T> void checkArgumentValid(T object, String errorMessage) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessage);
    }

    public static <T> void checkArgumentValid(T object, String errorMessageTemplate, Object ... errorMessageArgs) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessageTemplate, errorMessageArgs);
    }

    public static <T> void checkArgumentValid(T object, Function<Set<ConstraintViolation<T>>, String> errorMessageCreator) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessageCreator);
    }

    public static <T> void checkArgumentValid(T object, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object, groupClasses);
        KiwiValidations.checkArgumentNoViolations(violations);
    }

    public static <T> void checkArgumentValid(T object, String errorMessage, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object, groupClasses);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessage);
    }

    public static <T> void checkArgumentValid(T object, String errorMessageTemplate, List<Object> errorMessageArgs, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object, groupClasses);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessageTemplate, errorMessageArgs.toArray());
    }

    public static <T> void checkArgumentValid(T object, Function<Set<ConstraintViolation<T>>, String> errorMessageCreator, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(object, groupClasses);
        KiwiValidations.checkArgumentNoViolations(violations, errorMessageCreator);
    }

    public static <T> void checkArgumentNoViolations(Set<ConstraintViolation<T>> violations) {
        KiwiValidations.checkArgumentNoViolations(violations, KiwiConstraintViolations::simpleCombinedErrorMessageOrNull);
    }

    public static <T> void checkArgumentNoViolations(Set<ConstraintViolation<T>> violations, String errorMessage) {
        Preconditions.checkArgument((boolean)KiwiSets.isNullOrEmpty(violations), (Object)errorMessage);
    }

    public static <T> void checkArgumentNoViolations(Set<ConstraintViolation<T>> violations, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (KiwiSets.isNotNullOrEmpty(violations)) {
            String errorMessage = KiwiStrings.format(errorMessageTemplate, errorMessageArgs);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static <T> void checkArgumentNoViolations(Set<ConstraintViolation<T>> violations, Function<Set<ConstraintViolation<T>>, String> errorMessageCreator) {
        if (KiwiSets.isNotNullOrEmpty(violations)) {
            String errorMessage = KiwiValidations.getErrorMessageOrFallback(violations, errorMessageCreator);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static <T> String getErrorMessageOrFallback(Set<ConstraintViolation<T>> violations, Function<Set<ConstraintViolation<T>>, String> errorMessageCreator) {
        try {
            return errorMessageCreator.apply(violations);
        }
        catch (Exception e) {
            LOG.warn("errorMessageCreator threw exception creating message. Falling back to default message.", (Throwable)e);
            return KiwiConstraintViolations.simpleCombinedErrorMessageOrEmpty(violations).orElse("Argument contained one or more constraint violations");
        }
    }

    public static void addError(ConstraintValidatorContext context, String template) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(template).addConstraintViolation();
    }

    public static void addError(ConstraintValidatorContext context, String template, String propertyName) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(template).addPropertyNode(propertyName).addConstraintViolation();
    }

    public static @Nullable Object getPropertyValue(Object bean, String fieldName) {
        if (Objects.isNull(bean) || StringUtils.isBlank((CharSequence)fieldName)) {
            LOG.warn("bean is null or fieldName is blank; unable to continue so returning null");
            return null;
        }
        try {
            return KiwiReflection.findField(bean, fieldName).get(bean);
        }
        catch (Exception e) {
            LOG.warn("Unable to get value of property '{}' from object of type {}", new Object[]{fieldName, bean.getClass().getName(), e});
            return null;
        }
    }

    @Generated
    private KiwiValidations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

