/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.validation.InternalKiwiValidators;
import org.kiwiproject.validation.KiwiValidations;
import org.kiwiproject.validation.Range;
import org.kiwiproject.validation.Validity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeValidator
implements ConstraintValidator<Range, Object> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RangeValidator.class);
    private static final String TEMPLATE_BETWEEN_MIN_MAX_VALUES = "{org.kiwiproject.validation.Range.between.message.minMaxValues}";
    private static final String TEMPLATE_BETWEEN_MIN_MAX_LABELS = "{org.kiwiproject.validation.Range.between.message.minMaxLabels}";
    private static final String TEMPLATE_LESS_THAN_OR_EQ_MIN_MAX_VALUES = "{org.kiwiproject.validation.Range.lessThanOrEq.message.minMaxValues}";
    private static final String TEMPLATE_LESS_THAN_OR_EQ_MIN_MAX_LABELS = "{org.kiwiproject.validation.Range.lessThanOrEq.message.minMaxLabels}";
    private static final String TEMPLATE_GREATER_THAN_OR_EQ_MIN_MAX_VALUES = "{org.kiwiproject.validation.Range.greaterThanOrEq.message.minMaxValues}";
    private static final String TEMPLATE_GREATER_THAN_OR_EQ_MIN_MAX_LABELS = "{org.kiwiproject.validation.Range.greaterThanOrEq.message.minMaxLabels}";
    private static final String TEMPLATE_UNKNOWN_ERROR = "{org.kiwiproject.validation.FieldRange.unknownError.message}";
    private Range range;
    private String templateBetween;
    private String templateLessThanOrEq;
    private String templateGreaterThanOrEq;

    public void initialize(Range constraintAnnotation) {
        Preconditions.checkState((boolean)RangeValidator.hasMinOrMax(constraintAnnotation), (Object)"@Range must specify at least one of 'min' or 'max'");
        this.range = constraintAnnotation;
        boolean useLabels = StringUtils.isNotBlank((CharSequence)constraintAnnotation.minLabel()) || StringUtils.isNotBlank((CharSequence)constraintAnnotation.maxLabel());
        LOG.trace("minLabel and/or maxLabel exist, so label-based messages will be used");
        this.templateBetween = useLabels ? TEMPLATE_BETWEEN_MIN_MAX_LABELS : TEMPLATE_BETWEEN_MIN_MAX_VALUES;
        this.templateLessThanOrEq = useLabels ? TEMPLATE_LESS_THAN_OR_EQ_MIN_MAX_LABELS : TEMPLATE_LESS_THAN_OR_EQ_MIN_MAX_VALUES;
        this.templateGreaterThanOrEq = useLabels ? TEMPLATE_GREATER_THAN_OR_EQ_MIN_MAX_LABELS : TEMPLATE_GREATER_THAN_OR_EQ_MIN_MAX_VALUES;
    }

    private static boolean hasMinOrMax(Range constraintAnnotation) {
        return StringUtils.isNotBlank((CharSequence)constraintAnnotation.min()) || StringUtils.isNotBlank((CharSequence)constraintAnnotation.max());
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Validity validity;
        try {
            validity = this.checkNull(value, context);
            if (validity == Validity.CONTINUE) {
                validity = this.checkMinMax((Comparable)value, context);
            }
        }
        catch (Exception e) {
            KiwiValidations.addError(context, TEMPLATE_UNKNOWN_ERROR);
            RangeValidator.logWarning(value, e);
            validity = Validity.INVALID;
        }
        return validity == Validity.VALID;
    }

    private Validity checkNull(Object value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            if (this.range.allowNull()) {
                return Validity.VALID;
            }
            KiwiValidations.addError(context, "{org.kiwiproject.validation.Required.message}");
            return Validity.INVALID;
        }
        return Validity.CONTINUE;
    }

    private Validity checkMinMax(Comparable<Object> value, ConstraintValidatorContext context) {
        Verify.verify((boolean)Objects.nonNull(value), (String)"value should not be null at this point (checkNull should have returned INVALID)!", (Object[])new Object[0]);
        Comparable<Object> min = InternalKiwiValidators.toComparableOrNull(this.range.min(), value);
        Comparable<Object> max = InternalKiwiValidators.toComparableOrNull(this.range.max(), value);
        if (RangeValidator.hasBothMinAndMax(min, max) && RangeValidator.outsideRange(min, max, value)) {
            KiwiValidations.addError(context, this.templateBetween);
            return Validity.INVALID;
        }
        return this.checkMinOrMax(context, min, max, value);
    }

    private static boolean hasBothMinAndMax(Comparable<?> min, Comparable<?> max) {
        return Objects.nonNull(min) && Objects.nonNull(max);
    }

    private static boolean outsideRange(Comparable<?> min, Comparable<?> max, Comparable<Object> value) {
        return value.compareTo(min) < 0 || value.compareTo(max) > 0;
    }

    private Validity checkMinOrMax(ConstraintValidatorContext context, Comparable<?> min, Comparable<?> max, Comparable<Object> value) {
        if (Objects.nonNull(min) && value.compareTo(min) < 0) {
            KiwiValidations.addError(context, this.templateGreaterThanOrEq);
            return Validity.INVALID;
        }
        if (Objects.nonNull(max) && value.compareTo(max) > 0) {
            KiwiValidations.addError(context, this.templateLessThanOrEq);
            return Validity.INVALID;
        }
        return Validity.VALID;
    }

    private static void logWarning(Object value, Exception e) {
        String type;
        String string = type = Objects.isNull(value) ? null : value.getClass().getName();
        if (value instanceof Comparable) {
            LOG.warn("Error validating Range for value of type {} (which may not be supported) ; considering as invalid", (Object)type, (Object)e);
        } else {
            LOG.warn("Error validating Range for value of type {} that does not implement Comparable ; considering as invalid", (Object)type, (Object)e);
        }
    }
}

