/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jackson.KiwiTypeReferences;
import org.kiwiproject.yaml.RuntimeYamlException;

public class YamlHelper {
    private final ObjectMapper objectMapper;

    public YamlHelper() {
        this(new ObjectMapper((JsonFactory)YamlHelper.newYAMLFactory()));
    }

    private static YAMLFactory newYAMLFactory() {
        return new YAMLFactory().disable(YAMLGenerator.Feature.SPLIT_LINES);
    }

    public YamlHelper(ObjectMapper objectMapper) {
        KiwiPreconditions.checkArgumentNotNull(objectMapper, "objectMapper cannot be null");
        String supportedFormat = objectMapper.getFactory().getFormatName();
        Preconditions.checkArgument((boolean)"YAML".equals(supportedFormat), (Object)"ObjectMapper does not support YAML");
        this.objectMapper = objectMapper;
    }

    public String toYaml(Object object) {
        return this.toYaml(object, null);
    }

    public String toYaml(Object object, Class<?> yamlView) {
        ObjectWriter writer = this.objectMapper.writer();
        if (Objects.nonNull(yamlView)) {
            writer = writer.withView(yamlView);
        }
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeYamlException(e);
        }
    }

    public <T> T toObject(String yaml, Class<T> targetClass) {
        this.checkYamlNotBlank(yaml);
        try {
            return (T)this.objectMapper.readValue(yaml, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeYamlException(e);
        }
    }

    public <T> T toObject(String yaml, TypeReference<T> targetType) {
        this.checkYamlNotBlank(yaml);
        try {
            return (T)this.objectMapper.readValue(yaml, targetType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeYamlException(e);
        }
    }

    public <T> List<T> toObjectList(String yaml, TypeReference<List<T>> targetListType) {
        this.checkYamlNotBlank(yaml);
        return this.toObject(yaml, targetListType);
    }

    public Map<String, Object> toMap(String yaml) {
        return this.toMap(yaml, KiwiTypeReferences.MAP_OF_STRING_TO_OBJECT_TYPE_REFERENCE);
    }

    public <K, V> Map<K, V> toMap(String yaml, TypeReference<Map<K, V>> targetMapType) {
        this.checkYamlNotBlank(yaml);
        try {
            return (Map)this.objectMapper.readValue(yaml, targetMapType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeYamlException(e);
        }
    }

    public void checkYamlNotBlank(String yaml) {
        KiwiPreconditions.checkArgumentNotBlank(yaml, "yaml cannot be blank");
    }
}

