/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.metrics.health.HealthStatus;

public final class HealthCheckResults {
    public static final String SEVERITY_DETAIL = "severity";

    public static HealthCheck.Result newHealthyResult() {
        return HealthCheckResults.newHealthyResultBuilder().build();
    }

    public static HealthCheck.Result newHealthyResult(HealthStatus severity) {
        return HealthCheckResults.newHealthyResultBuilder(severity).build();
    }

    public static HealthCheck.Result newHealthyResult(String message) {
        return HealthCheckResults.newHealthyResultBuilder().withMessage(message).build();
    }

    public static HealthCheck.Result newHealthyResult(HealthStatus severity, String message) {
        return HealthCheckResults.newHealthyResultBuilder(severity).withMessage(message).build();
    }

    public static HealthCheck.Result newHealthyResult(String messageTemplate, Object ... args) {
        return HealthCheckResults.newHealthyResultBuilder().withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.Result newHealthyResult(HealthStatus severity, String messageTemplate, Object ... args) {
        return HealthCheckResults.newHealthyResultBuilder(severity).withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.Result newUnhealthyResult(String message) {
        return HealthCheckResults.newUnhealthyResultBuilder().withMessage(message).build();
    }

    public static HealthCheck.Result newUnhealthyResult(HealthStatus severity, String message) {
        return HealthCheckResults.newUnhealthyResultBuilder(severity).withMessage(message).build();
    }

    public static HealthCheck.Result newUnhealthyResult(String messageTemplate, Object ... args) {
        return HealthCheckResults.newUnhealthyResultBuilder().withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.Result newUnhealthyResult(HealthStatus severity, String messageTemplate, Object ... args) {
        return HealthCheckResults.newUnhealthyResultBuilder(severity).withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.Result newUnhealthyResult(Throwable error) {
        return HealthCheckResults.newUnhealthyResultBuilder(error).build();
    }

    public static HealthCheck.Result newUnhealthyResult(HealthStatus severity, Throwable error) {
        return HealthCheckResults.newUnhealthyResultBuilder(severity, error).build();
    }

    public static HealthCheck.Result newUnhealthyResult(Throwable error, String message) {
        return HealthCheckResults.newUnhealthyResultBuilder(error).withMessage(message).build();
    }

    public static HealthCheck.Result newUnhealthyResult(HealthStatus severity, Throwable error, String message) {
        return HealthCheckResults.newUnhealthyResultBuilder(severity, error).withMessage(message).build();
    }

    public static HealthCheck.Result newUnhealthyResult(Throwable error, String messageTemplate, Object ... args) {
        return HealthCheckResults.newUnhealthyResultBuilder(error).withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.Result newUnhealthyResult(HealthStatus severity, Throwable error, String messageTemplate, Object ... args) {
        return HealthCheckResults.newUnhealthyResultBuilder(severity, error).withMessage(messageTemplate, args).build();
    }

    public static HealthCheck.ResultBuilder newResultBuilder(boolean healthy, HealthStatus severity) {
        HealthCheckResults.checkSeverity(severity);
        HealthCheckResults.checkValidCombination(healthy, severity);
        HealthCheck.ResultBuilder resultBuilder = HealthCheckResults.newEmptyResultBuilder(healthy);
        return HealthCheckResults.addSeverity(severity, resultBuilder);
    }

    private static HealthCheck.ResultBuilder newEmptyResultBuilder(boolean healthy) {
        if (healthy) {
            return HealthCheck.Result.builder().healthy();
        }
        return HealthCheck.Result.builder().unhealthy();
    }

    public static HealthCheck.ResultBuilder newResultBuilder(boolean healthy) {
        if (healthy) {
            return HealthCheckResults.newHealthyResultBuilder();
        }
        return HealthCheckResults.newUnhealthyResultBuilder();
    }

    public static HealthCheck.ResultBuilder newHealthyResultBuilder() {
        return HealthCheckResults.newHealthyResultBuilder(HealthStatus.OK);
    }

    public static HealthCheck.ResultBuilder newHealthyResultBuilder(HealthStatus severity) {
        HealthCheckResults.checkSeverity(severity);
        HealthCheckResults.checkValidCombination(true, severity);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().healthy();
        return HealthCheckResults.addSeverity(severity, resultBuilder);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder() {
        return HealthCheckResults.newUnhealthyResultBuilder(HealthStatus.WARN);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder(HealthStatus severity) {
        HealthCheckResults.checkSeverity(severity);
        HealthCheckResults.checkValidCombination(false, severity);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().unhealthy();
        return HealthCheckResults.addSeverity(severity, resultBuilder);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder(Throwable error) {
        HealthCheckResults.checkError(error);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().unhealthy(error);
        return HealthCheckResults.addSeverity(HealthStatus.CRITICAL, resultBuilder);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder(Throwable error, String message) {
        HealthCheckResults.checkError(error);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().unhealthy(error).withMessage(message);
        return HealthCheckResults.addSeverity(HealthStatus.CRITICAL, resultBuilder);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder(HealthStatus severity, Throwable error) {
        HealthCheckResults.checkError(error);
        HealthCheckResults.checkSeverity(severity);
        HealthCheckResults.checkValidCombination(false, severity);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().unhealthy(error);
        return HealthCheckResults.addSeverity(severity, resultBuilder);
    }

    public static HealthCheck.ResultBuilder newUnhealthyResultBuilder(HealthStatus severity, Throwable error, String message) {
        HealthCheckResults.checkError(error);
        HealthCheckResults.checkSeverity(severity);
        HealthCheckResults.checkValidCombination(false, severity);
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder().unhealthy(error).withMessage(message);
        return HealthCheckResults.addSeverity(severity, resultBuilder);
    }

    private static void checkValidCombination(boolean healthy, HealthStatus severity) {
        Preconditions.checkArgument((boolean)HealthStatus.isValidCombination(healthy, severity), (String)"Invalid combination (healthy, severity): (%s, %s)", (Object)healthy, (Object)((Object)severity));
    }

    private static void checkError(Throwable error) {
        KiwiPreconditions.checkArgumentNotNull((Object)error, (String)"error cannot be null");
    }

    public static HealthCheck.ResultBuilder addSeverity(HealthStatus severity, HealthCheck.ResultBuilder builder) {
        HealthCheckResults.checkBuilder(builder);
        HealthCheckResults.checkSeverity(severity);
        return builder.withDetail(SEVERITY_DETAIL, (Object)severity.name());
    }

    public static HealthCheck.Result resultWithSeverity(HealthStatus severity, HealthCheck.ResultBuilder builder) {
        return HealthCheckResults.addSeverity(severity, builder).build();
    }

    private static void checkBuilder(HealthCheck.ResultBuilder builder) {
        KiwiPreconditions.checkArgumentNotNull((Object)builder, (String)"builder cannot be null");
    }

    private static void checkSeverity(HealthStatus severity) {
        KiwiPreconditions.checkArgumentNotNull((Object)((Object)severity), (String)"severity cannot be null");
    }

    @Generated
    private HealthCheckResults() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

