/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.metrics.health;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.metrics.health.HealthStatusComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HealthStatus {
    OK(1),
    INFO(2),
    WARN(3),
    CRITICAL(4),
    FATAL(5);

    @Generated
    private static final Logger LOG;
    private final int value;

    private HealthStatus(int value) {
        this.value = value;
    }

    public static HealthStatus from(Map<String, Object> healthDetails) {
        if (KiwiMaps.isNullOrEmpty(healthDetails)) {
            return CRITICAL;
        }
        Set<HealthStatus> healthStatuses = healthDetails.values().stream().filter(Map.class::isInstance).map(Map.class::cast).map(HealthStatus::determineOverallStatus).collect(Collectors.toSet());
        if (healthStatuses.isEmpty()) {
            return CRITICAL;
        }
        if (healthStatuses.size() == 1) {
            return (HealthStatus)((Object)Iterables.getOnlyElement(healthStatuses));
        }
        return HealthStatus.highestSeverity(healthStatuses);
    }

    private static HealthStatus determineOverallStatus(Map<String, Object> map) {
        boolean healthy = HealthStatus.getHealthyValue(map);
        HealthStatus severity = HealthStatus.getHealthStatusOrNull(map);
        return HealthStatus.determineOverallStatus(healthy, severity);
    }

    private static boolean getHealthyValue(Map<String, Object> map) {
        try {
            String value = map.getOrDefault("healthy", Boolean.FALSE).toString();
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            LOG.warn("Something gave us a 'healthy' value that threw an exception on toString()");
            return false;
        }
    }

    private static HealthStatus getHealthStatusOrNull(Map<String, Object> map) {
        if (!map.containsKey("severity")) {
            return null;
        }
        Object severityObj = map.get("severity");
        String severity = HealthStatus.severityOrNull(severityObj);
        try {
            return Optional.ofNullable(severity).map(HealthStatus::valueOf).orElse(WARN);
        }
        catch (Exception e) {
            LOG.error("Something gave us an invalid severity: {} (returning WARN). Health map: {}", (Object)severity, map);
            return WARN;
        }
    }

    private static String severityOrNull(Object severityObj) {
        if (severityObj instanceof String) {
            return (String)severityObj;
        }
        LOG.warn("Something gave us a severity that was not a String: {}", severityObj);
        return null;
    }

    private static HealthStatus determineOverallStatus(boolean healthy, @Nullable HealthStatus severity) {
        if (HealthStatus.isInvalidCombination(healthy, severity)) {
            LOG.warn("Detected invalid (healthy, severity) combination: ({}, {})", (Object)healthy, (Object)severity);
            return HealthStatus.max(WARN, Optional.ofNullable(severity).orElse(WARN));
        }
        if (Objects.isNull((Object)severity)) {
            return HealthStatus.from(healthy);
        }
        if (healthy) {
            return HealthStatus.max(OK, severity);
        }
        return severity;
    }

    public static HealthStatus defaultSeverityForValue(boolean healthy) {
        return healthy ? OK : WARN;
    }

    public static boolean isValidCombination(boolean healthy, @Nullable HealthStatus severity) {
        return !HealthStatus.isInvalidCombination(healthy, severity);
    }

    public static boolean isInvalidCombination(boolean healthy, @Nullable HealthStatus severity) {
        if (Objects.isNull((Object)severity)) {
            return false;
        }
        boolean healthyWithInvalidSeverity = healthy && (severity == CRITICAL || severity == FATAL);
        boolean unhealthyWithInvalidSeverity = !healthy && severity == OK;
        return healthyWithInvalidSeverity || unhealthyWithInvalidSeverity;
    }

    public static HealthStatus from(Boolean value) {
        return BooleanUtils.toBoolean((Boolean)value) ? OK : WARN;
    }

    public static HealthStatus max(HealthStatus status1, HealthStatus status2) {
        KiwiPreconditions.checkArgumentNotNull((Object)((Object)status1));
        KiwiPreconditions.checkArgumentNotNull((Object)((Object)status2));
        return HealthStatus.compare(status1, status2) > 0 ? status1 : status2;
    }

    private static int compare(HealthStatus status1, HealthStatus status2) {
        return HealthStatus.comparingSeverity().compare(status1, status2);
    }

    public static HealthStatus highestSeverity(Collection<HealthStatus> statuses) {
        Preconditions.checkArgument((Objects.nonNull(statuses) && !statuses.isEmpty() ? 1 : 0) != 0, (Object)"statuses cannot be empty or null");
        return Collections.max(statuses, HealthStatus.comparingSeverity());
    }

    public static Comparator<HealthStatus> comparingSeverity() {
        return HealthStatusComparator.INSTANCE;
    }

    @Generated
    int getValue() {
        return this.value;
    }

    static {
        LOG = LoggerFactory.getLogger(HealthStatus.class);
    }
}

