/*
 * Decompiled with CFR 0.152.
 */
package org.kiwitcms.java.api;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.ConnectionConfigurator;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.kiwitcms.java.api.SessionConfigurator;
import org.kiwitcms.java.config.Config;

public class BaseRpcClient {
    public static final String BASE_URL = Config.getInstance().getUrl();
    protected static String sessionId;

    protected JSONRPC2Session prepareSession() {
        URL serverURL = null;
        try {
            serverURL = new URL(BASE_URL.replace("xml-rpc", "json-rpc"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        JSONRPC2Session mySession = new JSONRPC2Session(serverURL);
        mySession.getOptions().setRequestContentType("application/json");
        mySession.getOptions().trustAllCerts(true);
        mySession.setConnectionConfigurator((ConnectionConfigurator)new SessionConfigurator(sessionId));
        return mySession;
    }

    protected Object executeViaNamedParams(String serviceMethod, Map<String, Object> params) {
        JSONRPC2Session mySession = this.prepareSession();
        int requestID = 1;
        JSONRPC2Request request = new JSONRPC2Request(serviceMethod, (Object)requestID);
        request.setNamedParams(params);
        try {
            return this.getResponse(mySession.send(request));
        }
        catch (JSONRPC2SessionException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    protected Object executeViaPositionalParams(String serviceMethod, List<Object> params) {
        JSONRPC2Session mySession = this.prepareSession();
        int requestID = 1;
        JSONRPC2Request request = new JSONRPC2Request(serviceMethod, (Object)requestID);
        request.setPositionalParams(params);
        try {
            return this.getResponse(mySession.send(request));
        }
        catch (JSONRPC2SessionException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    protected Object getResponse(JSONRPC2Response response) {
        if (response.indicatesSuccess()) {
            return response.getResult();
        }
        System.out.println(response.getError().getMessage());
        return response.getError();
    }
}

