/*
 * Decompiled with CFR 0.152.
 */
package org.kiwitcms.java.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.kiwitcms.java.api.BaseRpcClient;
import org.kiwitcms.java.model.Build;
import org.kiwitcms.java.model.Priority;
import org.kiwitcms.java.model.Product;
import org.kiwitcms.java.model.TestCase;
import org.kiwitcms.java.model.TestExecution;
import org.kiwitcms.java.model.TestPlan;
import org.kiwitcms.java.model.TestRun;
import org.kiwitcms.java.model.Version;

public class RpcClient
extends BaseRpcClient {
    public static final String LOGIN_METHOD = "Auth.login";
    public static final String LOGOUT_METHOD = "Auth.logout";
    private static final String PRODUCT_FILTER = "Product.filter";
    private static final String CREATE_PRODUCT_METHOD = "Product.create";
    private static final String BUILD_FILTER = "Build.filter";
    private static final String CREATE_BUILD_METHOD = "Build.create";
    private static final String CREATE_VERSION_METHOD = "Version.create";
    private static final String VERSION_FILTER = "Version.filter";
    private static final String PRIORITY_FILTER = "Priority.filter";
    private static final String CATEGORY_FILTER = "Category.filter";
    private static final String GET_RUN_TCS_METHOD = "TestRun.get_cases";
    private static final String CREATE_RUN_METHOD = "TestRun.create";
    public static final String CREATE_TC_METHOD = "TestCase.create";
    private static final String TEST_CASE_FILTER = "TestCase.filter";
    private static final String ADD_TC_TO_RUN_METHOD = "TestRun.add_case";
    private static final String RUN_FILTER = "TestRun.filter";
    private static final String ADD_TC_TO_PLAN_METHOD = "TestPlan.add_case";
    private static final String CREATE_PLAN_METHOD = "TestPlan.create";
    private static final String TEST_PLAN_FILTER = "TestPlan.filter";
    private static final String TEST_EXECUTION_FILTER = "TestExecution.filter";
    private static final String TEST_EXECUTION_CREATE = "TestExecution.create";
    private static final String TEST_EXECUTION_UPDATE = "TestExecution.update";
    public static final String TEST_CASE_STATUS_FILTER = "TestCaseStatus.filter";

    public String login(String username, String password) {
        sessionId = (String)this.executeViaPositionalParams(LOGIN_METHOD, Arrays.asList(username, password));
        return sessionId;
    }

    public void logout() {
        JSONRPC2Session mySession = this.prepareSession();
        int requestID = 1;
        JSONRPC2Request request = new JSONRPC2Request(LOGOUT_METHOD, (Object)requestID);
        try {
            this.getResponse(mySession.send(request));
        }
        catch (JSONRPC2SessionException e) {
            System.err.println(e.getMessage());
        }
    }

    public TestCase createTestCase(int categoryId, int priorityId, int caseStatusId, String summary) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", categoryId);
        params.put("summary", summary);
        params.put("is_automated", "true");
        params.put("priority", priorityId);
        params.put("case_status", caseStatusId);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_TC_METHOD, Arrays.asList(params));
        try {
            return (TestCase)new ObjectMapper().readValue(json.toJSONString(), TestCase.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestCase getOrCreateTestCase(int productId, int categoryId, int priorityId, String summary) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("summary", summary);
        filter.put("category__product", productId);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_CASE_FILTER, Arrays.asList(filter));
        if (jsonArray == null || jsonArray.isEmpty()) {
            int caseStatusId = this.getConfirmedTCStatusId();
            return this.createTestCase(categoryId, priorityId, caseStatusId, summary);
        }
        try {
            TestCase[] testCases = (TestCase[])new ObjectMapper().readValue(jsonArray.toJSONString(), TestCase[].class);
            return testCases[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestRun createNewRun(int build, String manager, int plan, String summary) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("build", build);
        params.put("manager", manager);
        params.put("plan", plan);
        params.put("summary", summary);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_RUN_METHOD, Arrays.asList(params));
        try {
            return (TestRun)new ObjectMapper().readValue(json.toJSONString(), TestRun.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestCase[] getRunIdTestCases(int runId) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(GET_RUN_TCS_METHOD, Arrays.asList(runId));
        try {
            return (TestCase[])new ObjectMapper().readValue(jsonArray.toJSONString(), TestCase[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new TestCase[0];
        }
    }

    public TestExecution addTestCaseToRunId(int runId, int caseId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("run_id", runId);
        params.put("case_id", caseId);
        JSONObject json = (JSONObject)this.executeViaNamedParams(ADD_TC_TO_RUN_METHOD, params);
        try {
            return (TestExecution)new ObjectMapper().readValue(json.toJSONString(), TestExecution.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean planExists(int planId) {
        HashMap<String, Integer> filter = new HashMap<String, Integer>();
        filter.put("pk", planId);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_PLAN_FILTER, Arrays.asList(filter));
        return !jsonArray.isEmpty();
    }

    public int getTestPlanId(String name, int productId) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("name", name);
        filter.put("product", productId);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_PLAN_FILTER, Arrays.asList(filter));
        if (jsonArray == null || jsonArray.isEmpty()) {
            return -1;
        }
        try {
            TestPlan[] plans = (TestPlan[])new ObjectMapper().readValue(jsonArray.toJSONString(), TestPlan[].class);
            return plans[0].getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public TestRun getRun(int runId) {
        HashMap<String, Integer> filter = new HashMap<String, Integer>();
        filter.put("pk", runId);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(RUN_FILTER, Arrays.asList(filter));
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        try {
            TestRun[] run = (TestRun[])new ObjectMapper().readValue(jsonArray.toJSONString(), TestRun[].class);
            return run[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestPlan createNewTP(int productId, String name, int versionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "Unit");
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams("PlanType.filter", Arrays.asList(params));
        Object type = ((JSONObject)jsonArray.get(0)).get((Object)"id");
        params = new HashMap();
        params.put("product", productId);
        params.put("type", type);
        params.put("default_product_version", 0);
        params.put("product_version", versionId);
        params.put("text", "WIP");
        params.put("is_active", true);
        params.put("name", name);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_PLAN_METHOD, Arrays.asList(params));
        try {
            return (TestPlan)new ObjectMapper().readValue(json.toJSONString(), TestPlan.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addTestCaseToPlan(int planId, int caseId) {
        HashMap<String, Integer> filter = new HashMap<String, Integer>();
        filter.put("pk", caseId);
        filter.put("plan", planId);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_CASE_FILTER, Arrays.asList(filter));
        if (jsonArray == null || jsonArray.isEmpty()) {
            this.executeViaPositionalParams(ADD_TC_TO_PLAN_METHOD, Arrays.asList(planId, caseId));
        }
    }

    public TestExecution getTestExecution(Map<String, Object> filter) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_EXECUTION_FILTER, Arrays.asList(filter));
        if (jsonArray.isEmpty()) {
            return null;
        }
        try {
            TestExecution[] tcRun = (TestExecution[])new ObjectMapper().readValue(jsonArray.toJSONString(), TestExecution[].class);
            return tcRun[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestExecution createTestExecution(int runId, int caseId, int build, int status) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("run", runId);
        params.put("case", caseId);
        params.put("build", build);
        params.put("status", status);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(TEST_EXECUTION_CREATE, Arrays.asList(params));
        try {
            return (TestExecution)new ObjectMapper().readValue(json.toJSONString(), TestExecution.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TestExecution updateTestExecution(int tcRunId, int status) {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("status", status);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("execution_id", tcRunId);
        params.put("values", values);
        JSONObject json = (JSONObject)this.executeViaNamedParams(TEST_EXECUTION_UPDATE, params);
        try {
            return (TestExecution)new ObjectMapper().readValue(json.toJSONString(), TestExecution.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONArray getTestCaseStatus(Map<String, Object> filter) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(TEST_CASE_STATUS_FILTER, Arrays.asList(filter));
        return jsonArray;
    }

    public int getConfirmedTCStatusId() {
        HashMap<String, Object> confirmed_params = new HashMap<String, Object>();
        confirmed_params.put("name", "CONFIRMED");
        Object id = ((JSONObject)this.getTestCaseStatus(confirmed_params).get(0)).get((Object)"id");
        return Integer.parseInt(String.valueOf(id));
    }

    public Integer getProductId(String name) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("name", name);
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(PRODUCT_FILTER, Arrays.asList(filter));
        if (jsonArray.isEmpty()) {
            return null;
        }
        try {
            Product[] product = (Product[])new ObjectMapper().readValue(jsonArray.toJSONString(), Product[].class);
            return product[0].getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Product createNewProduct(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams("Classification.filter", Arrays.asList(params));
        Object classificationId = ((JSONObject)jsonArray.get(0)).get((Object)"id");
        params.put("name", name);
        params.put("classification_id", classificationId);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_PRODUCT_METHOD, Arrays.asList(params));
        try {
            return (Product)new ObjectMapper().readValue(json.toJSONString(), Product.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Build[] getBuilds(Map<String, Object> filter) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(BUILD_FILTER, Arrays.asList(filter));
        if (jsonArray.isEmpty()) {
            return new Build[0];
        }
        try {
            Build[] builds = (Build[])new ObjectMapper().readValue(jsonArray.toJSONString(), Build[].class);
            return builds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Build[0];
        }
    }

    public Build createBuild(String name, int productId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("product", productId);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_BUILD_METHOD, Arrays.asList(params));
        try {
            return (Build)new ObjectMapper().readValue(json.toJSONString(), Build.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Version[] getVersions(Map<String, Object> filter) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(VERSION_FILTER, Arrays.asList(filter));
        if (jsonArray.isEmpty()) {
            return new Version[0];
        }
        try {
            Version[] versions = (Version[])new ObjectMapper().readValue(jsonArray.toJSONString(), Version[].class);
            return versions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Version[0];
        }
    }

    public Version createProductVersion(String version, int productId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", version);
        params.put("product", productId);
        JSONObject json = (JSONObject)this.executeViaPositionalParams(CREATE_VERSION_METHOD, Arrays.asList(params));
        try {
            return (Version)new ObjectMapper().readValue(json.toJSONString(), Version.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Priority[] getPriority(Map<String, Object> filter) {
        JSONArray jsonArray = (JSONArray)this.executeViaPositionalParams(PRIORITY_FILTER, Arrays.asList(filter));
        if (jsonArray.isEmpty()) {
            return new Priority[0];
        }
        try {
            return (Priority[])new ObjectMapper().readValue(jsonArray.toJSONString(), Priority[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Priority[0];
        }
    }

    public JSONArray getCategory(Map<String, Object> filter) {
        return (JSONArray)this.executeViaPositionalParams(CATEGORY_FILTER, Arrays.asList(filter));
    }
}

