/*
 * Decompiled with CFR 0.152.
 */
package org.kiwitcms.java.config;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;

public class Config {
    private IniPreferences config;
    private static Config instance;

    private Config() {
        try {
            String home_dir = System.getProperty("user.home");
            this.config = new IniPreferences(new Ini(new File(home_dir + "/.tcms.conf")));
        }
        catch (IOException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public static Config getInstance() {
        if (null == instance) {
            instance = new Config();
        }
        return instance;
    }

    public String getUrl() {
        return Optional.ofNullable(this.config.node("tcms").get("url", null)).orElse(System.getenv("TCMS_API_URL"));
    }

    public String getUsername() {
        return Optional.ofNullable(this.config.node("tcms").get("username", null)).orElse(System.getenv("TCMS_USERNAME"));
    }

    public String getPassword() {
        return Optional.ofNullable(this.config.node("tcms").get("password", null)).orElse(System.getenv("TCMS_PASSWORD"));
    }

    public Integer getRunId() {
        String runId = System.getenv("TCMS_RUN_ID");
        if (runId == null) {
            return null;
        }
        return Integer.parseInt(runId.trim());
    }

    public String getProduct() {
        return Optional.ofNullable(System.getenv("TCMS_PRODUCT")).orElse(Optional.ofNullable(System.getenv("TRAVIS_REPO_SLUG")).orElse(System.getenv("JOB_NAME")));
    }

    public String getProductVersion() {
        return Optional.ofNullable(System.getenv("TCMS_PRODUCT_VERSION")).orElse(Optional.ofNullable(System.getenv("TRAVIS_COMMIT")).orElse(Optional.ofNullable(System.getenv("TRAVIS_PULL_REQUEST_SHA")).orElse(System.getenv("GIT_COMMIT"))));
    }

    public String getBuild() {
        return Optional.ofNullable(System.getenv("TCMS_BUILD")).orElse(Optional.ofNullable(System.getenv("TRAVIS_BUILD_NUMBER")).orElse(System.getenv("BUILD_NUMBER")));
    }
}

