/*
 * Decompiled with CFR 0.152.
 */
package org.kiwitcms.java.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ConfigurationException;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.kiwitcms.java.config.Config;
import org.kiwitcms.java.junit.TestDataEmitter;
import org.kiwitcms.java.model.TestMethod;

public class KiwiTcmsExtension
extends SummaryGeneratingListener
implements AfterAllCallback,
AfterEachCallback,
BeforeAllCallback {
    private List<TestMethod> tests;

    public void beforeAll(ExtensionContext context) throws ConfigurationException {
        Config config = Config.getInstance();
        if (config.getUrl().isEmpty() || config.getUsername().isEmpty() || config.getPassword().isEmpty()) {
            throw new ConfigurationException("API URL, username and password must be configured");
        }
        this.tests = new ArrayList<TestMethod>();
    }

    public void afterAll(ExtensionContext context) {
        TestDataEmitter emitter = new TestDataEmitter();
        int runId = emitter.getTestRunId();
        emitter.addTestResultsToRun(runId, this.tests);
        emitter.closeSession();
    }

    public void afterEach(ExtensionContext context) {
        if (context.getTestMethod().isPresent()) {
            Method method = (Method)context.getTestMethod().get();
            TestMethod test = new TestMethod();
            test.name = method.getName();
            if (context.getExecutionException().isPresent()) {
                test.exception = (Throwable)context.getExecutionException().get();
                test.result = "FAIL";
            } else {
                test.result = "PASS";
            }
            test.containingClass = method.getDeclaringClass().getSimpleName();
            this.tests.add(test);
        }
    }
}

