/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoincore.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoincore.BitcoinCore;
import org.knowm.xchange.bitcoincore.dto.BitcoinCoreException;
import org.knowm.xchange.bitcoincore.dto.account.BitcoinCoreBalanceRequest;
import org.knowm.xchange.bitcoincore.dto.account.BitcoinCoreBalanceResponse;
import org.knowm.xchange.bitcoincore.dto.account.BitcoinCoreUnconfirmedBalanceRequest;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseExchangeService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.ClientConfigUtil;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class BitcoinCoreAccountServiceRaw
extends BaseExchangeService {
    private final BitcoinCore bitcoinCore;
    private final BitcoinCoreBalanceRequest balanceRequest = new BitcoinCoreBalanceRequest();
    private final BitcoinCoreUnconfirmedBalanceRequest unconfirmedBalanceRequest = new BitcoinCoreUnconfirmedBalanceRequest();

    protected BitcoinCoreAccountServiceRaw(Exchange exchange) {
        super(exchange);
        ExchangeSpecification specification = exchange.getExchangeSpecification();
        ClientConfig config = new ClientConfig();
        String user = specification.getUserName();
        ClientConfigUtil.addBasicAuthCredentials((ClientConfig)config, (String)(user == null ? "" : user), (String)specification.getPassword());
        this.bitcoinCore = (BitcoinCore)RestProxyFactory.createProxy(BitcoinCore.class, (String)specification.getPlainTextUri(), (ClientConfig)config, (Interceptor[])new Interceptor[0]);
    }

    public BitcoinCoreBalanceResponse getBalance() throws IOException {
        try {
            return this.bitcoinCore.getBalance(this.balanceRequest);
        }
        catch (BitcoinCoreException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public BitcoinCoreBalanceResponse getUnconfirmedBalance() throws IOException {
        try {
            return this.bitcoinCore.getUnconfirmedBalance(this.unconfirmedBalanceRequest);
        }
        catch (BitcoinCoreException e) {
            throw new ExchangeException((Throwable)e);
        }
    }
}

