/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinium;

import java.util.Arrays;
import java.util.List;

public final class BitcoiniumUtils {
    public static final List<String> PRICE_WINDOW = Arrays.asList("TWO_PERCENT", "FIVE_PERCENT", "TEN_PERCENT", "TWENTY_PERCENT", "FIFTY_PERCENT", "ONE_HUNDRED_PERCENT");
    public static final List<String> TIME_WINDOW = Arrays.asList("ONE_HOUR", "THREE_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS", "THREE_DAYS", "SEVEN_DAYS", "THIRTY_DAYS", "TWO_MONTHS");

    private BitcoiniumUtils() {
    }

    public static String createCurrencyPairString(String tradableIdentifier, String currency) {
        return tradableIdentifier + "_" + currency;
    }

    public static boolean isValidPriceWindow(String priceWindow) {
        return PRICE_WINDOW.contains(priceWindow);
    }

    public static boolean isValidTimeWindow(String timeWindow) {
        return TIME_WINDOW.contains(timeWindow);
    }
}

