/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinium.service.polling;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcoinium.BitcoiniumAdapters;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import org.knowm.xchange.bitcoinium.service.polling.BitcoiniumMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.polling.marketdata.PollingMarketDataService;

public class BitcoiniumMarketDataService
extends BitcoiniumMarketDataServiceRaw
implements PollingMarketDataService {
    public BitcoiniumMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        BitcoiniumTicker bitcoiniumTicker = this.getBitcoiniumTicker(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode());
        return BitcoiniumAdapters.adaptTicker(bitcoiniumTicker, currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        Object arg0;
        String priceWindow = "";
        if (args.length == 1) {
            arg0 = args[0];
            if (!(arg0 instanceof String)) {
                throw new ExchangeException("priceWindow argument must be a String!");
            }
        } else {
            throw new ExchangeException("Exactly 1 String arguments is necessary: the priceWindow!");
        }
        priceWindow = (String)arg0;
        BitcoiniumOrderbook bitcoiniumOrderbook = this.getBitcoiniumOrderbook(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), priceWindow);
        return BitcoiniumAdapters.adaptOrderbook(bitcoiniumOrderbook, currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }
}

