/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinium.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinium.Bitcoinium;
import org.knowm.xchange.bitcoinium.BitcoiniumUtils;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTickerHistory;
import org.knowm.xchange.bitcoinium.service.BitcoiniumBaseService;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.utils.Assert;

public class BitcoiniumMarketDataServiceRaw
extends BitcoiniumBaseService {
    private final Bitcoinium bitcoinium;

    public BitcoiniumMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitcoinium = (Bitcoinium)ExchangeRestProxyBuilder.forInterface(Bitcoinium.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public BitcoiniumTicker getBitcoiniumTicker(String tradableIdentifier, String currency) throws IOException {
        String pair = BitcoiniumUtils.createCurrencyPairString(tradableIdentifier, currency);
        BitcoiniumTicker bitcoiniumTicker = this.bitcoinium.getTicker(pair, this.exchange.getExchangeSpecification().getApiKey());
        return bitcoiniumTicker;
    }

    public BitcoiniumTickerHistory getBitcoiniumTickerHistory(String tradableIdentifier, String currency, String timeWindow) throws IOException {
        String pair = BitcoiniumUtils.createCurrencyPairString(tradableIdentifier, currency);
        this.verifyTimeWindow(timeWindow);
        BitcoiniumTickerHistory bitcoiniumTickerHistory = this.bitcoinium.getTickerHistory(pair, timeWindow, this.exchange.getExchangeSpecification().getApiKey());
        return bitcoiniumTickerHistory;
    }

    public BitcoiniumOrderbook getBitcoiniumOrderbook(String tradableIdentifier, String currency, String orderbookwindow) throws IOException {
        String pair = BitcoiniumUtils.createCurrencyPairString(tradableIdentifier, currency);
        this.verifyPriceWindow(orderbookwindow);
        BitcoiniumOrderbook bitcoiniumDepth = this.bitcoinium.getDepth(pair, orderbookwindow, this.exchange.getExchangeSpecification().getApiKey());
        return bitcoiniumDepth;
    }

    private void verifyPriceWindow(String priceWindow) {
        Assert.isTrue((boolean)BitcoiniumUtils.isValidPriceWindow(priceWindow), (String)(priceWindow + " is not a valid price window!"));
    }

    private void verifyTimeWindow(String timeWindow) {
        Assert.isTrue((boolean)BitcoiniumUtils.isValidTimeWindow(timeWindow), (String)(timeWindow + " is not a valid time window!"));
    }
}

