/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinium;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public final class BitcoiniumAdapters {
    private BitcoiniumAdapters() {
    }

    public static Ticker adaptTicker(BitcoiniumTicker bitcoiniumTicker, CurrencyPair currencyPair) {
        BigDecimal last = bitcoiniumTicker.getLast();
        BigDecimal high = bitcoiniumTicker.getHigh();
        BigDecimal low = bitcoiniumTicker.getLow();
        BigDecimal ask = bitcoiniumTicker.getAsk();
        BigDecimal bid = bitcoiniumTicker.getBid();
        BigDecimal volume = bitcoiniumTicker.getVolume();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).high(high).low(low).volume(volume).ask(ask).bid(bid).build();
    }

    public static OrderBook adaptOrderbook(BitcoiniumOrderbook bitcoiniumOrderbook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = BitcoiniumAdapters.createOrders(currencyPair, Order.OrderType.ASK, bitcoiniumOrderbook.getAsks());
        List<LimitOrder> bids = BitcoiniumAdapters.createOrders(currencyPair, Order.OrderType.BID, bitcoiniumOrderbook.getBids());
        Date date = new Date(bitcoiniumOrderbook.getBitcoiniumTicker().getTimestamp());
        return new OrderBook(date, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, BitcoiniumOrderbook.CondensedOrder[] condensedOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (int i = 0; i < condensedOrders.length; ++i) {
            LimitOrder limitOrder = new LimitOrder(orderType, condensedOrders[i].getVolume(), (Instrument)currencyPair, "", null, condensedOrders[i].getPrice());
            limitOrders.add(limitOrder);
        }
        return limitOrders;
    }
}

