/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v1;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bitfinex.v1.dto.BitfinexExceptionV1;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLend;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLendDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexSymbolDetail;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;

@Path(value="v1")
@Produces(value={"application/json"})
public interface Bitfinex {
    @GET
    @Path(value="pubticker/{symbol}")
    public BitfinexTicker getTicker(@PathParam(value="symbol") String var1) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="book/{symbol}")
    public BitfinexDepth getBook(@PathParam(value="symbol") String var1, @QueryParam(value="limit_bids") int var2, @QueryParam(value="limit_asks") int var3) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="book/{symbol}")
    public BitfinexDepth getBook(@PathParam(value="symbol") String var1) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="lendbook/{currency}")
    public BitfinexLendDepth getLendBook(@PathParam(value="currency") String var1, @QueryParam(value="limit_bids") int var2, @QueryParam(value="limit_asks") int var3) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="trades/{symbol}")
    public BitfinexTrade[] getTrades(@PathParam(value="symbol") String var1, @QueryParam(value="timestamp") long var2) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="lends/{currency}")
    public BitfinexLend[] getLends(@PathParam(value="currency") String var1, @QueryParam(value="timestamp") long var2, @QueryParam(value="limit_trades") int var4) throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="symbols")
    public Set<String> getSymbols() throws IOException, BitfinexExceptionV1;

    @GET
    @Path(value="symbols_details")
    public List<BitfinexSymbolDetail> getSymbolsDetails() throws IOException, BitfinexExceptionV1;
}

