/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v1.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.dto.Order;

public class BitfinexActivePositionsResponse {
    private final long id;
    private final String symbol;
    private final String status;
    private final BigDecimal base;
    private final BigDecimal amount;
    private final BigDecimal timestamp;
    private final BigDecimal swap;
    private final BigDecimal pnl;
    private final Order.OrderType orderType;

    public BitfinexActivePositionsResponse(@JsonProperty(value="id") long id, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="status") String status, @JsonProperty(value="base") BigDecimal base, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="timestamp") BigDecimal timestamp, @JsonProperty(value="swap") BigDecimal swap, @JsonProperty(value="pl") BigDecimal pnl) {
        this.id = id;
        this.symbol = symbol;
        this.status = status;
        this.base = base;
        this.amount = amount;
        this.timestamp = timestamp;
        this.swap = swap;
        this.pnl = pnl;
        this.orderType = amount.signum() < 0 ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    public long getId() {
        return this.id;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getStatus() {
        return this.status;
    }

    public BigDecimal getBase() {
        return this.base;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getSwap() {
        return this.swap;
    }

    public BigDecimal getPnl() {
        return this.pnl;
    }

    public Order.OrderType getOrderType() {
        return this.orderType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BitfinexActivePositionsResponse [id=");
        builder.append(this.id);
        builder.append(", symbol=");
        builder.append(this.symbol);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", base=");
        builder.append(this.base);
        builder.append(", amount=");
        builder.append(this.amount);
        builder.append(", timestamp=");
        builder.append(this.timestamp);
        builder.append(", swap=");
        builder.append(this.swap);
        builder.append(", pnl=");
        builder.append(this.pnl);
        builder.append(", orderType=");
        builder.append(this.orderType);
        builder.append("]");
        return builder.toString();
    }
}

