/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v1.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

public class BitfinexNewOrderRequest {
    @JsonProperty(value="request")
    protected String request = "/v1/order/new";
    @JsonProperty(value="nonce")
    protected String nonce;
    @JsonProperty(value="symbol")
    protected String symbol;
    @JsonProperty(value="exchange")
    protected String exchange;
    @JsonProperty(value="side")
    protected String side;
    @JsonProperty(value="type")
    protected String type;
    @JsonProperty(value="amount")
    protected String amount;
    @JsonProperty(value="price")
    protected String price;
    @JsonProperty(value="is_hidden")
    protected boolean is_hidden = false;
    @JsonProperty(value="is_postonly")
    protected boolean is_postonly = false;
    @JsonProperty(value="ocoorder")
    protected boolean ocoorder = false;
    @JsonProperty(value="buy_price_oco")
    protected String buy_price_oco;
    @JsonProperty(value="sell_price_oco")
    protected String sell_price_oco;

    public BitfinexNewOrderRequest(String nonce, String symbol, BigDecimal amount, BigDecimal price, String exchange, String side, String type, BigDecimal ocoAmount) {
        this.nonce = nonce;
        this.symbol = symbol;
        if (amount != null) {
            this.amount = amount.toPlainString();
        }
        if (price != null) {
            this.price = price.toPlainString();
        }
        this.exchange = exchange;
        this.side = side;
        this.type = type;
        if (ocoAmount != null) {
            this.ocoorder = true;
            if (side.equals("sell")) {
                this.sell_price_oco = ocoAmount.toPlainString();
            } else {
                this.buy_price_oco = ocoAmount.toPlainString();
            }
        }
    }

    public BitfinexNewOrderRequest(String nonce, String symbol, BigDecimal amount, BigDecimal price, String exchange, String side, String type, boolean isHidden, boolean isPostOnly, BigDecimal ocoAmount) {
        this(nonce, symbol, amount, price, exchange, side, type, ocoAmount);
        this.is_hidden = isHidden;
        this.is_postonly = isPostOnly;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getSide() {
        return this.side;
    }

    public String getType() {
        return this.type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getAmount() {
        if (this.amount == null) {
            return null;
        }
        return this.amount;
    }

    public String getPrice() {
        if (this.price == null) {
            return null;
        }
        return this.price;
    }
}

