/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.ws.rs.HeaderParam;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestInvocation;

public class BitfinexHmacSignature
extends BaseParamsDigest {
    private static final Logger log = LoggerFactory.getLogger(BitfinexHmacSignature.class);
    private static final String UTF_8 = "UTF-8";

    private BitfinexHmacSignature(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA384");
    }

    public static BitfinexHmacSignature createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new BitfinexHmacSignature(secretKeyBase64);
    }

    public String digestParams(RestInvocation i) {
        String path = i.getPath();
        try {
            path = URLDecoder.decode(path, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not url decode the path {}.", (Object)path, (Object)e);
        }
        Object nonce = i.getParamValue(HeaderParam.class, "bfx-nonce");
        String body = i.getRequestBody();
        if (body == null || body.isEmpty()) {
            body = "{}";
        }
        String toEncode = "/api/" + path + nonce + body;
        try {
            byte[] sig = this.getMac().doFinal(toEncode.getBytes(UTF_8));
            String signature = DigestUtils.bytesToHex((byte[])sig);
            return signature;
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            throw new ExchangeException("Could not sign the request", (Throwable)e);
        }
    }
}

