/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.knowm.xchange.exceptions.ExchangeException;

public final class BitstampUtils {
    public static final int MAX_TRANSACTIONS_PER_QUERY = 1000;
    private static final ZoneId BITSTAMP_DATE_TIME_ZONE_ID = ZoneId.of("UTC");
    private static final DateTimeFormatter BITSTAMP_DATE_TIME_PATTERN = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();

    private BitstampUtils() {
    }

    public static Date parseDate(String dateString) {
        try {
            if (dateString == null) {
                return null;
            }
            Instant instant = LocalDateTime.parse(dateString, BITSTAMP_DATE_TIME_PATTERN).atZone(BITSTAMP_DATE_TIME_ZONE_ID).toInstant();
            return Date.from(instant);
        }
        catch (DateTimeParseException e) {
            throw new ExchangeException("Illegal date/time format", (Throwable)e);
        }
    }
}

