/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.bitstamp.BitstampUtils;
import org.knowm.xchange.currency.Currency;

public class WithdrawalRequest {
    private final Date datetime;
    private Long id;
    private Type type;
    private BigDecimal amount;
    private Currency currency;
    @JsonProperty(value="status")
    private String statusOriginal;
    private String data;
    private String address;
    @JsonProperty(value="transaction_id")
    private String transactionId;

    public WithdrawalRequest(@JsonProperty(value="datetime") String datetime) {
        this.datetime = BitstampUtils.parseDate(datetime);
    }

    public Long getId() {
        return this.id;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Status getStatus() {
        return Status.fromString(this.statusOriginal);
    }

    @JsonProperty(value="status")
    public String getStatusOriginal() {
        return this.statusOriginal;
    }

    public String getData() {
        return this.data;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String toString() {
        return "WithdrawalRequest [id=" + this.id + ", datetime=" + this.datetime + ", type=" + (Object)((Object)this.type) + ", amount=" + this.amount + ", status=" + (Object)((Object)this.getStatus()) + ", statusOriginal=" + this.statusOriginal + ", data=" + this.data + ", address=" + this.address + ", transactionId=" + this.transactionId + "]";
    }

    public static enum Status {
        open,
        in_process,
        finished,
        canceled,
        failed,
        unknown;


        @JsonCreator
        public static Status fromString(String string) {
            switch (string) {
                case "0": {
                    return open;
                }
                case "1": {
                    return in_process;
                }
                case "2": {
                    return finished;
                }
                case "3": {
                    return canceled;
                }
                case "4": {
                    return failed;
                }
            }
            return unknown;
        }
    }

    public static enum Type {
        SEPA,
        bitcoin,
        wire,
        rippleUSD,
        rippleBTC,
        XRP,
        litecoin,
        ETH,
        unknown;


        @JsonCreator
        public static Type fromString(Integer string) {
            switch (string) {
                case 0: {
                    return SEPA;
                }
                case 1: {
                    return bitcoin;
                }
                case 2: {
                    return wire;
                }
                case 6: {
                    return rippleUSD;
                }
                case 7: {
                    return rippleBTC;
                }
                case 14: {
                    return XRP;
                }
                case 15: {
                    return litecoin;
                }
                case 16: {
                    return ETH;
                }
            }
            return unknown;
        }
    }
}

