/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitstamp.BitstampAuthenticated;
import org.knowm.xchange.bitstamp.BitstampAuthenticatedV2;
import org.knowm.xchange.bitstamp.BitstampV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.BitstampTransferBalanceResponse;
import org.knowm.xchange.bitstamp.dto.account.BitstampBalance;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampRippleDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.account.DepositTransaction;
import org.knowm.xchange.bitstamp.dto.account.WithdrawalRequest;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampBaseService;
import org.knowm.xchange.bitstamp.service.BitstampDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitstampAccountServiceRaw
extends BitstampBaseService {
    private final BitstampDigest signatureCreator;
    private final BitstampAuthenticated bitstampAuthenticated;
    private final BitstampAuthenticatedV2 bitstampAuthenticatedV2;
    private final String apiKey;
    private final SynchronizedValueFactory<Long> nonceFactory;

    protected BitstampAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitstampAuthenticated = (BitstampAuthenticated)ExchangeRestProxyBuilder.forInterface(BitstampAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.bitstampAuthenticatedV2 = (BitstampAuthenticatedV2)ExchangeRestProxyBuilder.forInterface(BitstampAuthenticatedV2.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BitstampDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), this.apiKey);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public BitstampBalance getBitstampBalance() throws IOException {
        try {
            BitstampBalance bitstampBalance = this.bitstampAuthenticated.getBalance(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (bitstampBalance.getError() != null) {
                throw new ExchangeException("Error getting balance. " + bitstampBalance.getError());
            }
            return bitstampBalance;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawBitstampFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        BitstampWithdrawal response = null;
        if (currency.equals((Object)Currency.XRP)) {
            BitstampRippleDepositAddress addressAndDt = new BitstampRippleDepositAddress(null, address);
            response = this.withdrawRippleFunds(amount, addressAndDt.getAddress(), Long.toString(addressAndDt.getDestinationTag()));
        } else if (currency.equals((Object)Currency.BTC)) {
            response = this.withdrawBtcFunds(amount, address);
        } else if (currency.equals((Object)Currency.LTC)) {
            response = this.withdrawLtcFunds(amount, address);
        } else if (currency.equals((Object)Currency.BCH)) {
            response = this.withdrawBchFunds(amount, address);
        } else if (currency.equals((Object)Currency.ETH)) {
            response = this.withdrawEthFunds(amount, address);
        } else {
            throw new ExchangeException(String.format("Withdrawing funds from Bitstamp failed.Unsupported currency %s", currency));
        }
        if (response.error != null) {
            throw new ExchangeException("Failed to withdraw: " + response.error);
        }
        if (response.getId() == null) {
            return null;
        }
        return response;
    }

    public BitstampWithdrawal withdrawBtcFunds(BigDecimal amount, String address) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticated.withdrawBitcoin(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawLtcFunds(BigDecimal amount, String address) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.withdrawLitecoin(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawEthFunds(BigDecimal amount, String address) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.withdrawEther(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawRippleFunds(BigDecimal amount, String address, String destinationTag) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.xrpWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address, destinationTag);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawBchFunds(BigDecimal amount, String address) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.bchWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    private BitstampWithdrawal checkAndReturnWithdrawal(BitstampWithdrawal response) {
        try {
            if (response.hasError()) {
                if (response.toString().contains("You have only")) {
                    throw new FundsExceededException(response.toString());
                }
                throw new ExchangeException("Withdrawing funds from Bitstamp failed: " + response.toString());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampBitcoinDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticated.getBitcoinDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampBitcoinCashDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticated.getBitcoinCashDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampLitecoinDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticated.getLitecoinDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampEthereumDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticated.getEthereumDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampRippleDepositAddress getRippleDepositAddress() throws IOException {
        return this.bitstampAuthenticated.getRippleDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public boolean withdrawToRipple(BigDecimal amount, Currency currency, String rippleAddress) throws IOException {
        try {
            return this.bitstampAuthenticated.withdrawToRipple(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, currency.getCurrencyCode(), rippleAddress);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public List<DepositTransaction> getUnconfirmedDeposits() throws IOException {
        try {
            List<DepositTransaction> response = Arrays.asList(this.bitstampAuthenticated.getUnconfirmedDeposits(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory()));
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public List<WithdrawalRequest> getWithdrawalRequests(Long timeDelta) throws IOException {
        try {
            List<WithdrawalRequest> response = Arrays.asList(this.bitstampAuthenticatedV2.getWithdrawalRequests(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), timeDelta));
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, CurrencyPair pair, Long offset, String sort, Long sinceTimestamp, Long sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, new BitstampV2.Pair(pair), numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, Long offset, String sort, Long sinceTimestamp, Long sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampTransferBalanceResponse transferSubAccountBalanceToMain(BigDecimal amount, String currency, String subAccount) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.transferSubAccountBalanceToMain(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, amount, currency, subAccount);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawSepa(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2) throws IOException {
        return this.withdrawSepa(amount, name, IBAN, BIK, address, postalCode, city, countryAlpha2, null);
    }

    public BitstampWithdrawal withdrawSepa(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String comment) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.bankWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, BitstampAuthenticatedV2.AccountCurrency.EUR, name, IBAN, BIK, address, postalCode, city, countryAlpha2, BitstampAuthenticatedV2.BankWithdrawalType.sepa, null, null, null, null, null, null, comment);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawInternational(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String bankName, String bankAddress, String bankPostalCode, String bankCity, String bankCountryAlpha2, BitstampAuthenticatedV2.BankCurrency bankReceiverCurrency) throws IOException {
        return this.withdrawInternational(amount, name, IBAN, BIK, address, postalCode, city, countryAlpha2, bankName, bankAddress, bankPostalCode, bankCity, bankCountryAlpha2, bankReceiverCurrency, null);
    }

    public BitstampWithdrawal withdrawInternational(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String bankName, String bankAddress, String bankPostalCode, String bankCity, String bankCountryAlpha2, BitstampAuthenticatedV2.BankCurrency bankReceiverCurrency, String comment) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.bankWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, BitstampAuthenticatedV2.AccountCurrency.EUR, name, IBAN, BIK, address, postalCode, city, countryAlpha2, BitstampAuthenticatedV2.BankWithdrawalType.international, bankName, bankAddress, bankPostalCode, bankCity, bankCountryAlpha2, bankReceiverCurrency, comment);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }
}

