/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitstamp.BitstampAuthenticated;
import org.knowm.xchange.bitstamp.BitstampAuthenticatedV2;
import org.knowm.xchange.bitstamp.BitstampV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrder;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderStatusResponse;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampBaseService;
import org.knowm.xchange.bitstamp.service.BitstampDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitstampTradeServiceRaw
extends BitstampBaseService {
    private final BitstampAuthenticated bitstampAuthenticated;
    private final BitstampAuthenticatedV2 bitstampAuthenticatedV2;
    private final BitstampDigest signatureCreator;
    private final String apiKey;
    private final SynchronizedValueFactory<Long> nonceFactory;

    public BitstampTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitstampAuthenticated = (BitstampAuthenticated)ExchangeRestProxyBuilder.forInterface(BitstampAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.bitstampAuthenticatedV2 = (BitstampAuthenticatedV2)ExchangeRestProxyBuilder.forInterface(BitstampAuthenticatedV2.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.nonceFactory = exchange.getNonceFactory();
        this.signatureCreator = BitstampDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), this.apiKey);
    }

    public BitstampOrder[] getBitstampOpenOrders(CurrencyPair pair) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getOpenOrders(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, new BitstampV2.Pair(pair));
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampOrder placeBitstampMarketOrder(CurrencyPair pair, BitstampAuthenticatedV2.Side side, BigDecimal originalAmount) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.placeMarketOrder(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, side, new BitstampV2.Pair(pair), originalAmount);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampOrder placeBitstampOrder(CurrencyPair pair, BitstampAuthenticatedV2.Side side, BigDecimal originalAmount, BigDecimal price) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.placeOrder(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, side, new BitstampV2.Pair(pair), originalAmount, price);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public boolean cancelBitstampOrder(long orderId) throws IOException {
        try {
            return this.bitstampAuthenticated.cancelOrder(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, orderId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public boolean cancelAllBitstampOrders() throws IOException {
        try {
            return this.bitstampAuthenticated.cancelAllOrders(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, CurrencyPair pair) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, new BitstampV2.Pair(pair), numberOfTransactions, null, null, null, null);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions) throws IOException {
        return this.getBitstampUserTransactions(numberOfTransactions, null, null, null, null);
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, CurrencyPair pair, Long offset, String sort, Long sinceTimestamp, Long sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, new BitstampV2.Pair(pair), numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, Long offset, String sort, Long sinceTimestamp, Long sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKey, (ParamsDigest)this.signatureCreator, this.nonceFactory, numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampOrderStatusResponse getBitstampOrder(Long orderId) throws IOException {
        try {
            return this.bitstampAuthenticated.getOrderStatus(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }
}

