/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;

@JsonDeserialize(using=BitstampDepositAddressDeserializer.class)
public class BitstampRippleDepositAddress
extends BitstampDepositAddress {
    @JsonProperty(value="address")
    private String addressAndDt;
    private final String address;
    private final Long destinationTag;

    public BitstampRippleDepositAddress(String error, String address, Long destinationTag) {
        super(error, address);
        String[] split = address.split("\\?dt=");
        if (split.length == 2) {
            this.address = split[0];
            this.destinationTag = Long.parseLong(split[1]);
            this.addressAndDt = address;
        } else {
            this.address = address;
            this.addressAndDt = destinationTag != null ? address + "?dt=" + destinationTag : address;
            this.destinationTag = destinationTag;
        }
    }

    public String getAddressAndDt() {
        return this.addressAndDt;
    }

    public String getAddress() {
        return this.address;
    }

    public Long getDestinationTag() {
        return this.destinationTag;
    }

    @Override
    public String toString() {
        return this.address == null ? this.addressAndDt : String.format("RippleAddress[%s, dt=%s]", this.address, this.destinationTag);
    }

    static class BitstampDepositAddressDeserializer
    extends JsonDeserializer<BitstampDepositAddress> {
        BitstampDepositAddressDeserializer() {
        }

        public BitstampRippleDepositAddress deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (node.get("error") != null) {
                return new BitstampRippleDepositAddress(node.path("error").asText(), "", null);
            }
            Long destinationTag = null;
            if (node.get("address") != null) {
                String address = node.get("address").asText();
                if (node.get("destination_tag") != null) {
                    destinationTag = node.get("destination_tag").asLong();
                }
                return new BitstampRippleDepositAddress(null, address, destinationTag);
            }
            return new BitstampRippleDepositAddress(null, node.asText(), null);
        }
    }
}

