/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.blockchain.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.blockchain.BlockchainUtils;
import org.knowm.xchange.blockchain.dto.Txs;

public final class BitcoinAddress {
    private final String address;
    private final long finalBalance;
    private final String hash160;
    private final int numTransactions;
    private final long totalReceived;
    private final long totalSent;
    private final List<Txs> txs;

    public BitcoinAddress(@JsonProperty(value="address") String address, @JsonProperty(value="final_balance") long final_balance, @JsonProperty(value="hash160") String hash160, @JsonProperty(value="n_tx") int n_tx, @JsonProperty(value="total_received") long total_received, @JsonProperty(value="total_sent") long total_sent, @JsonProperty(value="txs") List<Txs> txs) {
        this.address = address;
        this.finalBalance = final_balance;
        this.hash160 = hash160;
        this.numTransactions = n_tx;
        this.totalReceived = total_received;
        this.totalSent = total_sent;
        this.txs = txs;
    }

    public String getAddress() {
        return this.address;
    }

    public long getFinalBalance() {
        return this.finalBalance;
    }

    public BigDecimal getFinalBalanceDecimal() {
        return BlockchainUtils.getAmount(this.finalBalance);
    }

    public String getHash160() {
        return this.hash160;
    }

    public int getNumTransactions() {
        return this.numTransactions;
    }

    public long getTotalReceived() {
        return this.totalReceived;
    }

    public BigDecimal getTotalReceivedDecimal() {
        return BlockchainUtils.getAmount(this.totalReceived);
    }

    public long getTotalSent() {
        return this.totalSent;
    }

    public BigDecimal getTotalSentDecimal() {
        return BlockchainUtils.getAmount(this.totalSent);
    }

    public List<Txs> getTxs() {
        return this.txs;
    }

    public String toString() {
        return "BitcoinAddress [address=" + this.address + ", finalBalance=" + this.finalBalance + ", hash160=" + this.hash160 + ", numTransactions=" + this.numTransactions + ", totalReceived=" + this.totalReceived + ", totalSent=" + this.totalSent + "]";
    }
}

