/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;

public class CryptoFacilitiesInstrument
extends CryptoFacilitiesResult {
    private final boolean tradeable;
    private final Date lastTradingTime;
    private final String symbol;
    private final String underlying;
    private final BigDecimal contractSize;
    private final String type;
    private final BigDecimal tickSize;

    public CryptoFacilitiesInstrument(@JsonProperty(value="result") String result, @JsonProperty(value="error") String error, @JsonProperty(value="tradeable") String strTradeable, @JsonProperty(value="lastTradingTime") String strLastTradingTime, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="underlying") String underlying, @JsonProperty(value="contractSize") BigDecimal contractSize, @JsonProperty(value="type") String type, @JsonProperty(value="tickSize") BigDecimal tickSize) throws ParseException {
        super(result, error);
        this.tradeable = strTradeable.equalsIgnoreCase("true");
        this.lastTradingTime = Util.parseDate(strLastTradingTime);
        this.symbol = symbol;
        this.underlying = underlying;
        this.contractSize = contractSize;
        this.type = type;
        this.tickSize = tickSize;
    }

    public Boolean getTradeable() {
        return this.tradeable;
    }

    public Date getLastTradingTime() {
        return this.lastTradingTime;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public BigDecimal getContractSize() {
        return this.contractSize;
    }

    public String getType() {
        return this.type;
    }

    public BigDecimal getTickSize() {
        return this.tickSize;
    }

    @Override
    public String toString() {
        return "CryptoFacilitiesInstrument [tradeable=" + this.tradeable + ", lastTradingTime=" + this.lastTradingTime + ", symbol=" + this.symbol + ", underlying=" + this.underlying + ", contractSize=" + this.contractSize + ", type=" + this.type + ", tickSize=" + this.tickSize + " ]";
    }
}

