/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;

public class CryptoFacilitiesOpenOrder
extends CryptoFacilitiesResult {
    private final Date receivedTime;
    private final String status;
    private final String order_id;
    private final String orderType;
    private final String symbol;
    private final String side;
    private final BigDecimal unfilledSize;
    private final BigDecimal filledSize;
    private final BigDecimal limitPrice;
    private final BigDecimal stopPrice;

    public CryptoFacilitiesOpenOrder(@JsonProperty(value="result") String result, @JsonProperty(value="error") String error, @JsonProperty(value="receivedTime") String strReceivedTime, @JsonProperty(value="status") String status, @JsonProperty(value="order_id") String order_id, @JsonProperty(value="orderType") String orderType, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="side") String side, @JsonProperty(value="unfilledSize") BigDecimal unfilledSize, @JsonProperty(value="filledSize") BigDecimal filledSize, @JsonProperty(value="limitPrice") BigDecimal limitPrice, @JsonProperty(value="stopPrice") BigDecimal stopPrice) throws ParseException {
        super(result, error);
        this.receivedTime = Util.parseDate(strReceivedTime);
        this.status = status;
        this.order_id = order_id;
        this.orderType = orderType;
        this.symbol = symbol;
        this.side = side;
        this.unfilledSize = unfilledSize;
        this.filledSize = filledSize;
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
    }

    public Date getTimestamp() {
        return this.receivedTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getId() {
        return this.order_id;
    }

    public String getType() {
        return this.orderType;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDirection() {
        return this.side;
    }

    public BigDecimal getUnfilled() {
        return this.unfilledSize;
    }

    public BigDecimal getFilled() {
        return this.filledSize;
    }

    public BigDecimal getQuantity() {
        return this.filledSize.add(this.unfilledSize);
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    public BigDecimal getStopPrice() {
        return this.stopPrice;
    }

    @Override
    public String toString() {
        return "CryptoFacilitiesOpenOrder [order_id=" + this.order_id + ", status=" + this.status + ", orderType=" + this.orderType + ", symbol=" + this.symbol + ", dir=" + this.side + ", unfilled=" + this.unfilledSize + ", filled=" + this.filledSize + ", qty=" + this.getQuantity() + ", limitPrice=" + this.limitPrice + ", stopPrice=" + this.stopPrice + ", receivedTime=" + this.receivedTime + "]";
    }
}

