/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOpenPosition;

public class CryptoFacilitiesOpenPositions
extends CryptoFacilitiesResult {
    private final Date serverTime;
    private final List<CryptoFacilitiesOpenPosition> openPositions;

    public CryptoFacilitiesOpenPositions(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") String strServerTime, @JsonProperty(value="error") String error, @JsonProperty(value="openPositions") List<CryptoFacilitiesOpenPosition> openPositions) throws ParseException {
        super(result, error);
        this.serverTime = Util.parseDate(strServerTime);
        this.openPositions = openPositions;
    }

    public List<CryptoFacilitiesOpenPosition> getOpenPositions() {
        return this.openPositions;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            StringBuilder res = new StringBuilder("CryptoFacilitiesOpenPositions [serverTime=" + this.serverTime + ", openPositions=");
            for (CryptoFacilitiesOpenPosition openPosition : this.openPositions) {
                res.append(openPosition.toString()).append(", ");
            }
            res.append(" ]");
            return res.toString();
        }
        return super.toString();
    }
}

