/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Date;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOrderStatus;

public class CryptoFacilitiesOrder
extends CryptoFacilitiesResult {
    private final Date serverTime;
    private final CryptoFacilitiesOrderStatus orderStatus;
    private final String orderId;

    public CryptoFacilitiesOrder(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") String strServerTime, @JsonProperty(value="sendStatus") CryptoFacilitiesOrderStatus orderStatus, @JsonProperty(value="error") String error, @JsonProperty(value="orderId") String orderId) throws ParseException {
        super(result, error);
        this.serverTime = Util.parseDate(strServerTime);
        this.orderStatus = orderStatus;
        this.orderId = orderStatus == null ? orderId : orderStatus.getOrderId();
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getStatus() {
        return this.orderStatus == null ? this.getError() : this.orderStatus.getStatus();
    }

    @Override
    public String toString() {
        if (this.isSuccess() && this.serverTime != null && this.orderStatus != null) {
            String res = "CryptoFacilitiesOrder [result=" + this.getResult() + ", serverTime=" + this.serverTime + ", " + this.orderStatus.toString() + "]";
            return res;
        }
        return super.toString();
    }
}

