/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesBidsAsks;
import org.knowm.xchange.currency.CurrencyPair;

public class CryptoFacilitiesOrderBook
extends CryptoFacilitiesResult {
    private final Date serverTime;
    private final CryptoFacilitiesBidsAsks bidsAsks;
    private CurrencyPair currencyPair;

    public CryptoFacilitiesOrderBook(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") String strServerTime, @JsonProperty(value="error") String error, @JsonProperty(value="orderBook") CryptoFacilitiesBidsAsks bidsAsks) throws ParseException {
        super(result, error);
        this.serverTime = Util.parseDate(strServerTime);
        this.bidsAsks = bidsAsks;
    }

    public List<List<BigDecimal>> getBids() {
        return this.bidsAsks.getBids();
    }

    public List<List<BigDecimal>> getAsks() {
        return this.bidsAsks.getAsks();
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            return "CryptoFacilitiesOrderBook [ccyPair=" + this.currencyPair + ", serverTime=" + this.serverTime + ", orderBook=" + this.bidsAsks.toString() + "]";
        }
        return super.toString();
    }
}

