/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesPublicFill;
import org.knowm.xchange.currency.CurrencyPair;

public class CryptoFacilitiesPublicFills
extends CryptoFacilitiesResult {
    private final Date serverTime;
    private final List<CryptoFacilitiesPublicFill> fills;
    private CurrencyPair currencyPair;

    public CryptoFacilitiesPublicFills(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") String strServerTime, @JsonProperty(value="error") String error, @JsonProperty(value="history") List<CryptoFacilitiesPublicFill> fills) throws ParseException {
        super(result, error);
        this.serverTime = Util.parseDate(strServerTime);
        this.fills = fills;
    }

    public List<CryptoFacilitiesPublicFill> getFills() {
        return this.fills;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            StringBuilder res = new StringBuilder("CryptoFacilitiesPublicFills [serverTime=" + this.serverTime + ", ccyPair=" + this.currencyPair + ", fills=");
            for (CryptoFacilitiesPublicFill fill : this.fills) {
                res.append(fill.toString()).append(", ");
            }
            res.append(" ]");
            return res.toString();
        }
        return super.toString();
    }
}

