/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.CryptoFacilitiesResult;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesTicker;

public class CryptoFacilitiesTickers
extends CryptoFacilitiesResult {
    private final Date serverTime;
    private final List<CryptoFacilitiesTicker> tickers;

    public CryptoFacilitiesTickers(@JsonProperty(value="result") String result, @JsonProperty(value="serverTime") String strServerTime, @JsonProperty(value="error") String error, @JsonProperty(value="tickers") List<CryptoFacilitiesTicker> tickers) throws ParseException {
        super(result, error);
        this.serverTime = Util.parseDate(strServerTime);
        this.tickers = tickers;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public List<CryptoFacilitiesTicker> getTickers() {
        return this.tickers;
    }

    public CryptoFacilitiesTicker getTicker(String symbol) {
        if (this.isSuccess() && this.tickers != null) {
            for (CryptoFacilitiesTicker ticker : this.tickers) {
                if (ticker == null || !ticker.getSymbol().equalsIgnoreCase(symbol)) continue;
                return ticker;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            StringBuilder res = new StringBuilder("CryptoFacilitiesTickers [serverTime=" + this.serverTime + ", tickers=");
            for (CryptoFacilitiesTicker ticker : this.tickers) {
                res.append(ticker.toString()).append(", ");
            }
            res.append(" ]");
            return res.toString();
        }
        return super.toString();
    }
}

