/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesInstruments;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOrderBook;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesPublicFills;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesTicker;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesTickers;
import org.knowm.xchange.cryptofacilities.service.CryptoFacilitiesBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;

public class CryptoFacilitiesMarketDataServiceRaw
extends CryptoFacilitiesBaseService {
    public CryptoFacilitiesMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CryptoFacilitiesTicker getCryptoFacilitiesTicker(CurrencyPair currencyPair) throws IOException {
        CryptoFacilitiesTicker ticker = this.getCryptoFacilitiesTickers().getTicker(currencyPair.base.toString());
        return ticker;
    }

    public CryptoFacilitiesTickers getCryptoFacilitiesTickers() throws IOException {
        CryptoFacilitiesTickers tickers = this.cryptoFacilities.getTickers();
        if (tickers.isSuccess()) {
            return tickers;
        }
        throw new ExchangeException("Error getting CF tickers: " + tickers.getError());
    }

    public CryptoFacilitiesInstruments getCryptoFacilitiesInstruments() throws IOException {
        CryptoFacilitiesInstruments instruments = this.cryptoFacilities.getInstruments();
        if (instruments.isSuccess()) {
            return instruments;
        }
        throw new ExchangeException("Error getting CF instruments: " + instruments.getError());
    }

    public CryptoFacilitiesOrderBook getCryptoFacilitiesOrderBook(CurrencyPair currencyPair) throws IOException {
        CryptoFacilitiesOrderBook orderBook = this.cryptoFacilities.getOrderBook(currencyPair.base.toString());
        if (orderBook.isSuccess()) {
            orderBook.setCurrencyPair(currencyPair);
            return orderBook;
        }
        throw new ExchangeException("Error getting CF order book: " + orderBook.getError());
    }

    public CryptoFacilitiesPublicFills getCryptoFacilitiesHistory(CurrencyPair currencyPair) throws IOException {
        CryptoFacilitiesPublicFills publicFills = this.cryptoFacilities.getHistory(currencyPair.base.toString());
        if (publicFills.isSuccess()) {
            publicFills.setCurrencyPair(currencyPair);
            return publicFills;
        }
        throw new ExchangeException("Error getting CF public fills: " + publicFills.getError());
    }
}

