/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.cryptofacilities.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.cryptofacilities.Util;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesCancel;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesCancelAllOrdersAfter;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesFills;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOpenOrders;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOpenPositions;
import org.knowm.xchange.cryptofacilities.dto.marketdata.CryptoFacilitiesOrder;
import org.knowm.xchange.cryptofacilities.dto.trade.BatchOrder;
import org.knowm.xchange.cryptofacilities.dto.trade.BatchOrderResult;
import org.knowm.xchange.cryptofacilities.dto.trade.CryptoFacilitiesOrderFlags;
import org.knowm.xchange.cryptofacilities.dto.trade.OrderCommand;
import org.knowm.xchange.cryptofacilities.service.CryptoFacilitiesBaseService;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class CryptoFacilitiesTradeServiceRaw
extends CryptoFacilitiesBaseService {
    public CryptoFacilitiesTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CryptoFacilitiesOrder sendCryptoFacilitiesLimitOrder(LimitOrder order) throws IOException {
        String orderType = order.hasFlag((Order.IOrderFlags)CryptoFacilitiesOrderFlags.POST_ONLY) ? "post" : "lmt";
        String symbol = order.getCurrencyPair().base.toString();
        String side = "buy";
        if (order.getType().equals((Object)Order.OrderType.ASK)) {
            side = "sell";
        }
        BigDecimal size = order.getOriginalAmount();
        BigDecimal limitPrice = order.getLimitPrice();
        CryptoFacilitiesOrder ord = this.cryptoFacilities.sendOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderType, symbol, side, size, limitPrice);
        if (ord.isSuccess()) {
            return ord;
        }
        throw new ExchangeException("Error sending CF limit order: " + ord.getError());
    }

    public BatchOrderResult sendCryptoFacilitiesBatchOrder(List<OrderCommand> commands) throws IOException {
        BatchOrderResult ord = this.cryptoFacilities.batchOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new BatchOrder(commands));
        if (ord.isSuccess()) {
            return ord;
        }
        throw new ExchangeException("Error sending CF batch order: " + ord.getError());
    }

    public CryptoFacilitiesCancel cancelCryptoFacilitiesOrder(String uid) throws IOException {
        CryptoFacilitiesCancel res = this.cryptoFacilities.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uid);
        if (res.isSuccess()) {
            return res;
        }
        throw new ExchangeException("Error cancelling CF order: " + res.getError());
    }

    public CryptoFacilitiesOpenOrders getCryptoFacilitiesOpenOrders() throws IOException {
        CryptoFacilitiesOpenOrders openOrders = this.cryptoFacilities.openOrders(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (openOrders.isSuccess()) {
            return openOrders;
        }
        throw new ExchangeException("Error getting CF open orders: " + openOrders.getError());
    }

    public CryptoFacilitiesFills getCryptoFacilitiesFills() throws IOException {
        return this.getCryptoFacilitiesFills(null);
    }

    public CryptoFacilitiesFills getCryptoFacilitiesFills(Date lastFillTime) throws IOException {
        CryptoFacilitiesFills fills = this.cryptoFacilities.fills(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), Util.format(lastFillTime));
        if (fills.isSuccess()) {
            return fills;
        }
        throw new ExchangeException("Error getting CF fills: " + fills.getError());
    }

    public CryptoFacilitiesOpenPositions getCryptoFacilitiesOpenPositions() throws IOException {
        CryptoFacilitiesOpenPositions openPositions = this.cryptoFacilities.openPositions(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (openPositions.isSuccess()) {
            return openPositions;
        }
        throw new ExchangeException("Error getting CF open positions: " + openPositions.getError());
    }

    public CryptoFacilitiesCancelAllOrdersAfter cancelAllOrdersAfter(long timeoutSeconds) throws IOException {
        CryptoFacilitiesCancelAllOrdersAfter cancelallordersafter = this.cryptoFacilities.cancelAllOrdersAfter(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), timeoutSeconds);
        if (cancelallordersafter.isSuccess()) {
            return cancelallordersafter;
        }
        throw new ExchangeException("Error cancelling all CF orders after: " + cancelallordersafter.getError());
    }
}

