/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.anx.v2.marketdata;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.v2.service.ANXMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.examples.anx.v2.ANXExamplesUtils;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class ANXMarketdataDemo {
    public static void main(String[] args) throws IOException {
        Exchange anx = ANXExamplesUtils.createExchange();
        MarketDataService marketDataService = anx.getMarketDataService();
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        String btcusd = ticker.getLast().toString();
        System.out.println("Current exchange rate for BTC / USD: " + btcusd);
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Current Order Book size for BTC / USD: " + orderBook.getAsks().size() + orderBook.getBids().size());
        ANXMarketDataServiceRaw marketDataServiceRaw = (ANXMarketDataServiceRaw)marketDataService;
        Map tickers = marketDataServiceRaw.getANXTickers(anx.getExchangeMetaData().getCurrencyPairs().keySet());
        System.out.println(tickers);
        Map orderbooks = marketDataServiceRaw.getANXFullOrderBooks(anx.getExchangeMetaData().getCurrencyPairs().keySet());
        System.out.println(orderbooks);
    }
}

