/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinde;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinde.BitcoindeExchange;
import org.knowm.xchange.examples.bitcoinde.ExchangeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeUtils.class);

    public static Exchange createExchangeFromJsonConfiguration() throws IOException {
        ExchangeSpecification exSpec = new ExchangeSpecification(BitcoindeExchange.class);
        ObjectMapper mapper = new ObjectMapper();
        InputStream is = ExchangeUtils.class.getClassLoader().getResourceAsStream("bitcoinde/exchangeConfiguration.json");
        if (is == null) {
            logger.warn("No bitcoinde/exchangeConfiguration.json file found. Returning null exchange.");
            return null;
        }
        try {
            ExchangeConfiguration conf = (ExchangeConfiguration)mapper.readValue(is, ExchangeConfiguration.class);
            logger.debug(conf.toString());
            if (conf.apiKey != null) {
                exSpec.setApiKey(conf.apiKey);
            }
            if (conf.secretKey != null) {
                exSpec.setSecretKey(conf.secretKey);
            }
        }
        catch (Exception e) {
            logger.warn("An exception occured while loading the bitcoinde/exchangeConfiguration.json file from the classpath. Returning null exchange.", (Throwable)e);
            return null;
        }
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(exSpec);
        exchange.remoteInit();
        return exchange;
    }
}

