/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinde.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcoinde.dto.marketdata.BitcoindeOrderbookWrapper;
import org.knowm.xchange.bitcoinde.service.BitcoindeMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.examples.bitcoinde.ExchangeUtils;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcoindeOrderBookDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitcoindeExchange = ExchangeUtils.createExchangeFromJsonConfiguration();
        MarketDataService marketDataService = bitcoindeExchange.getMarketDataService();
        BitcoindeOrderBookDemo.generic(marketDataService);
    }

    public static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.ETH_EUR, new Object[0]);
        System.out.println("Current Order Book size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
    }

    public static void raw(BitcoindeMarketDataServiceRaw marketDataService) throws IOException {
        BitcoindeOrderbookWrapper bitcoindeOrderBook = marketDataService.getBitcoindeOrderBook(CurrencyPair.BTC_EUR);
        System.out.println(bitcoindeOrderBook.toString());
    }
}

