/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinde.marketdata;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcoinde.dto.marketdata.BitcoindeTrade;
import org.knowm.xchange.bitcoinde.dto.marketdata.BitcoindeTradesWrapper;
import org.knowm.xchange.bitcoinde.service.BitcoindeMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.examples.bitcoinde.ExchangeUtils;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcoindeTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitcoindeExchange = ExchangeUtils.createExchangeFromJsonConfiguration();
        MarketDataService marketDataService = bitcoindeExchange.getMarketDataService();
        BitcoindeTradesDemo.generic(marketDataService);
        BitcoindeTradesDemo.raw((BitcoindeMarketDataServiceRaw)marketDataService);
    }

    public static void generic(MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_EUR, new Object[0]);
        List allTrades = trades.getTrades();
        System.out.println("Number trades received: " + allTrades.size());
        for (Trade t : allTrades) {
            System.out.println(t);
        }
    }

    public static void raw(BitcoindeMarketDataServiceRaw marketDataService) throws IOException {
        BitcoindeTradesWrapper bitcoindeTrades = marketDataService.getBitcoindeTrades(CurrencyPair.ETH_EUR, Integer.valueOf(4196418));
        for (BitcoindeTrade bitcoindeTrade : bitcoindeTrades.getTrades()) {
            System.out.println(bitcoindeTrade);
        }
    }
}

