/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinium.BitcoiniumExchange;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import org.knowm.xchange.bitcoinium.service.BitcoiniumMarketDataServiceRaw;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class BitcoiniumOrderBookChartDemo {
    public static void main(String[] args) throws Exception {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(BitcoiniumExchange.class.getName());
        exchangeSpecification.setApiKey("42djci5kmbtyzrvglfdw3e2dgmh5mr37");
        System.out.println(exchangeSpecification.toString());
        Exchange bitcoiniumExchange = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        BitcoiniumMarketDataServiceRaw bitcoiniumMarketDataService = (BitcoiniumMarketDataServiceRaw)bitcoiniumExchange.getMarketDataService();
        System.out.println("fetching data...");
        BitcoiniumOrderbook bitcoiniumOrderbook = bitcoiniumMarketDataService.getBitcoiniumOrderbook("BTC", "BITSTAMP_USD", "TEN_PERCENT");
        System.out.println("Order book: " + bitcoiniumOrderbook);
        System.out.println("received data.");
        System.out.println("plotting...");
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Bitcoinium Order Book - BITSTAMP_BTC_USD")).xAxisTitle("BTC").yAxisTitle("USD").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        List<Float> bidsPriceData = BitcoiniumOrderBookChartDemo.getPriceData(bitcoiniumOrderbook.getBids());
        Collections.reverse(bidsPriceData);
        List<Float> bidsVolumeData = BitcoiniumOrderBookChartDemo.getVolumeData(bitcoiniumOrderbook.getBids());
        Collections.reverse(bidsVolumeData);
        XYSeries series = chart.addSeries("bids", bidsPriceData, bidsVolumeData);
        series.setMarker(SeriesMarkers.NONE);
        series = chart.addSeries("asks", BitcoiniumOrderBookChartDemo.getPriceData(bitcoiniumOrderbook.getAsks()), BitcoiniumOrderBookChartDemo.getVolumeData(bitcoiniumOrderbook.getAsks()));
        series.setMarker(SeriesMarkers.NONE);
        new SwingWrapper((Chart)chart).displayChart();
    }

    private static List<Float> getPriceData(BitcoiniumOrderbook.CondensedOrder[] condensedOrders) {
        ArrayList<Float> priceData = new ArrayList<Float>();
        for (int i = 0; i < condensedOrders.length; ++i) {
            priceData.add(Float.valueOf(condensedOrders[i].getPrice().floatValue()));
        }
        return priceData;
    }

    private static List<Float> getVolumeData(BitcoiniumOrderbook.CondensedOrder[] condensedOrders) {
        ArrayList<Float> volumeData = new ArrayList<Float>();
        for (int i = 0; i < condensedOrders.length; ++i) {
            volumeData.add(Float.valueOf(condensedOrders[i].getVolume().floatValue()));
        }
        return volumeData;
    }
}

