/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinium;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinium.BitcoiniumExchange;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import org.knowm.xchange.bitcoinium.service.BitcoiniumMarketDataServiceRaw;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class BitcoiniumRealtimeOrderbookDemo {
    XYChart chart;
    BitcoiniumMarketDataServiceRaw bitcoiniumMarketDataService;
    public static final String BIDS_SERIES_NAME = "bids";
    List<Float> xAxisBidData;
    List<Float> yAxisBidData;
    public static final String ASKS_SERIES_NAME = "asks";
    List<Float> xAxisAskData;
    List<Float> yAxisAskData;

    public static void main(String[] args) throws Exception {
        BitcoiniumRealtimeOrderbookDemo bitcoiniumRealtimeTickerDemo = new BitcoiniumRealtimeOrderbookDemo();
        bitcoiniumRealtimeTickerDemo.go();
    }

    private void go() throws IOException {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(BitcoiniumExchange.class.getName());
        exchangeSpecification.setApiKey("42djci5kmbtyzrvglfdw3e2dgmh5mr37");
        System.out.println(exchangeSpecification.toString());
        Exchange bitcoiniumExchange = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        this.bitcoiniumMarketDataService = (BitcoiniumMarketDataServiceRaw)bitcoiniumExchange.getMarketDataService();
        final XChartPanel<XYChart> chartPanel = this.buildPanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("XChart");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    BitcoiniumRealtimeOrderbookDemo.this.updateData();
                    BitcoiniumRealtimeOrderbookDemo.this.chart.updateXYSeries(BitcoiniumRealtimeOrderbookDemo.BIDS_SERIES_NAME, BitcoiniumRealtimeOrderbookDemo.this.xAxisBidData, BitcoiniumRealtimeOrderbookDemo.this.yAxisBidData, null);
                    BitcoiniumRealtimeOrderbookDemo.this.chart.updateXYSeries(BitcoiniumRealtimeOrderbookDemo.ASKS_SERIES_NAME, BitcoiniumRealtimeOrderbookDemo.this.xAxisAskData, BitcoiniumRealtimeOrderbookDemo.this.yAxisAskData, null);
                    chartPanel.revalidate();
                    chartPanel.repaint();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 10000L);
    }

    public XChartPanel<XYChart> buildPanel() throws IOException {
        System.out.println("fetching data...");
        this.updateData();
        this.chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(400)).title("Real-time Bitcoinium Order Book - BITSTAMP_BTC_USD")).xAxisTitle("BTC").yAxisTitle("USD").build();
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNE);
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        XYSeries series = this.chart.addSeries(BIDS_SERIES_NAME, this.xAxisBidData, this.yAxisBidData);
        series.setMarker(SeriesMarkers.NONE);
        series = this.chart.addSeries(ASKS_SERIES_NAME, this.xAxisAskData, this.yAxisAskData);
        series.setMarker(SeriesMarkers.NONE);
        return new XChartPanel((Chart)this.chart);
    }

    private void updateData() throws IOException {
        BitcoiniumOrderbook bitcoiniumOrderbook = this.bitcoiniumMarketDataService.getBitcoiniumOrderbook("BTC", "BITSTAMP_USD", "TEN_PERCENT");
        System.out.println(bitcoiniumOrderbook.toString());
        List<Float> bidsPriceData = BitcoiniumRealtimeOrderbookDemo.getPriceData(bitcoiniumOrderbook.getBids());
        Collections.reverse(bidsPriceData);
        List<Float> bidsVolumeData = BitcoiniumRealtimeOrderbookDemo.getVolumeData(bitcoiniumOrderbook.getBids());
        Collections.reverse(bidsVolumeData);
        this.xAxisBidData = bidsPriceData;
        this.yAxisBidData = bidsVolumeData;
        this.xAxisAskData = BitcoiniumRealtimeOrderbookDemo.getPriceData(bitcoiniumOrderbook.getAsks());
        this.yAxisAskData = BitcoiniumRealtimeOrderbookDemo.getVolumeData(bitcoiniumOrderbook.getAsks());
    }

    private static List<Float> getPriceData(BitcoiniumOrderbook.CondensedOrder[] condensedOrders) {
        ArrayList<Float> priceData = new ArrayList<Float>();
        for (int i = 0; i < condensedOrders.length; ++i) {
            priceData.add(Float.valueOf(condensedOrders[i].getPrice().floatValue()));
        }
        return priceData;
    }

    private static List<Float> getVolumeData(BitcoiniumOrderbook.CondensedOrder[] condensedOrders) {
        ArrayList<Float> volumeData = new ArrayList<Float>();
        for (int i = 0; i < condensedOrders.length; ++i) {
            volumeData.add(Float.valueOf(condensedOrders[i].getVolume().floatValue()));
        }
        return volumeData;
    }
}

