/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinium;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinium.BitcoiniumExchange;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTickerHistory;
import org.knowm.xchange.bitcoinium.service.BitcoiniumMarketDataServiceRaw;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class BitcoiniumRealtimeTickerDemo {
    XYChart chart;
    BitcoiniumMarketDataServiceRaw bitcoiniumMarketDataService;
    List<Date> xAxisData;
    List<Float> yAxisData;
    public static final String SERIES_NAME = "Bitcoinium USD/BTC";

    public static void main(String[] args) throws Exception {
        BitcoiniumRealtimeTickerDemo bitcoiniumRealtimeTickerDemo = new BitcoiniumRealtimeTickerDemo();
        bitcoiniumRealtimeTickerDemo.go();
    }

    private void go() throws IOException {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(BitcoiniumExchange.class.getName());
        exchangeSpecification.setApiKey("42djci5kmbtyzrvglfdw3e2dgmh5mr37");
        System.out.println(exchangeSpecification.toString());
        Exchange bitcoiniumExchange = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        this.bitcoiniumMarketDataService = (BitcoiniumMarketDataServiceRaw)bitcoiniumExchange.getMarketDataService();
        final XChartPanel<XYChart> chartPanel = this.buildPanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("XChart");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    BitcoiniumTicker bitcoiniumTicker = BitcoiniumRealtimeTickerDemo.this.bitcoiniumMarketDataService.getBitcoiniumTicker("BTC", "BITSTAMP_USD");
                    System.out.println(bitcoiniumTicker.toString());
                    Date timestamp = new Date(bitcoiniumTicker.getTimestamp());
                    float price = bitcoiniumTicker.getLast().floatValue();
                    if (BitcoiniumRealtimeTickerDemo.this.xAxisData.get(BitcoiniumRealtimeTickerDemo.this.xAxisData.size() - 1).getTime() != timestamp.getTime()) {
                        BitcoiniumRealtimeTickerDemo.this.xAxisData.add(timestamp);
                        BitcoiniumRealtimeTickerDemo.this.yAxisData.add(Float.valueOf(price));
                        XYSeries series = BitcoiniumRealtimeTickerDemo.this.chart.updateXYSeries(BitcoiniumRealtimeTickerDemo.SERIES_NAME, BitcoiniumRealtimeTickerDemo.this.xAxisData, BitcoiniumRealtimeTickerDemo.this.yAxisData, null);
                        chartPanel.revalidate();
                        chartPanel.repaint();
                        System.out.println(series.getXData());
                        System.out.println(series.getYData());
                    } else {
                        System.out.println("No new data.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 10000L);
    }

    public XChartPanel<XYChart> buildPanel() throws IOException {
        System.out.println("fetching data...");
        BitcoiniumTickerHistory bitcoiniumTickerHistory = this.bitcoiniumMarketDataService.getBitcoiniumTickerHistory("BTC", "BITSTAMP_USD", "THREE_HOURS");
        System.out.println(bitcoiniumTickerHistory.toString());
        this.xAxisData = new ArrayList<Date>();
        this.yAxisData = new ArrayList<Float>();
        for (int i = 0; i < bitcoiniumTickerHistory.getCondensedTickers().length; ++i) {
            BitcoiniumTicker bitcoiniumTicker = bitcoiniumTickerHistory.getCondensedTickers()[i];
            Date timestamp = new Date(bitcoiniumTicker.getTimestamp());
            float price = bitcoiniumTicker.getLast().floatValue();
            System.out.println(timestamp + ": " + price);
            this.xAxisData.add(timestamp);
            this.yAxisData.add(Float.valueOf(price));
        }
        this.chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Real-time Bitstamp Price vs. Time")).xAxisTitle("Time").yAxisTitle("Price").build();
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNE);
        XYSeries series = this.chart.addSeries(SERIES_NAME, this.xAxisData, this.yAxisData);
        series.setMarker(SeriesMarkers.NONE);
        return new XChartPanel((Chart)this.chart);
    }
}

