/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcoinium;

import java.util.ArrayList;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoinium.BitcoiniumExchange;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import org.knowm.xchange.bitcoinium.dto.marketdata.BitcoiniumTickerHistory;
import org.knowm.xchange.bitcoinium.service.BitcoiniumMarketDataServiceRaw;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class BitcoiniumTickerHistoryDemo {
    public static void main(String[] args) throws Exception {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(BitcoiniumExchange.class.getName());
        exchangeSpecification.setApiKey("42djci5kmbtyzrvglfdw3e2dgmh5mr37");
        System.out.println(exchangeSpecification.toString());
        Exchange bitcoiniumExchange = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        BitcoiniumMarketDataServiceRaw bitcoiniumMarketDataService = (BitcoiniumMarketDataServiceRaw)bitcoiniumExchange.getMarketDataService();
        System.out.println("fetching data...");
        BitcoiniumTickerHistory bitcoiniumTickerHistory = bitcoiniumMarketDataService.getBitcoiniumTickerHistory("BTC", "BITSTAMP_USD", "THIRTY_DAYS");
        System.out.println(bitcoiniumTickerHistory.toString());
        ArrayList<Date> xAxisData = new ArrayList<Date>();
        ArrayList<Float> yAxisData = new ArrayList<Float>();
        for (int i = 0; i < bitcoiniumTickerHistory.getCondensedTickers().length; ++i) {
            BitcoiniumTicker bitcoiniumTicker = bitcoiniumTickerHistory.getCondensedTickers()[i];
            Date timestamp = new Date(bitcoiniumTicker.getTimestamp());
            float price = bitcoiniumTicker.getLast().floatValue();
            System.out.println(timestamp + ": " + price);
            xAxisData.add(timestamp);
            yAxisData.add(Float.valueOf(price));
        }
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Bitstamp Price vs. Date")).xAxisTitle("Date").yAxisTitle("Price").build();
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNE);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        XYSeries series = chart.addSeries("Bitcoinium USD/BTC", xAxisData, yAxisData);
        series.setMarker(SeriesMarkers.NONE);
        new SwingWrapper((Chart)chart).displayChart();
    }
}

