/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcurex;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitcurex.BitcurexExchange;
import org.knowm.xchange.bitcurex.dto.marketdata.BitcurexDepth;
import org.knowm.xchange.bitcurex.service.BitcurexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcurexDepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitcurex = ExchangeFactory.INSTANCE.createExchange(BitcurexExchange.class.getName());
        BitcurexDepthDemo.requestData(bitcurex, CurrencyPair.BTC_EUR);
        BitcurexDepthDemo.requestData(bitcurex, CurrencyPair.BTC_PLN);
    }

    private static void requestData(Exchange bitcurex, CurrencyPair pair) throws IOException {
        MarketDataService marketDataService = bitcurex.getMarketDataService();
        BitcurexDepthDemo.generic(marketDataService, pair);
        BitcurexDepthDemo.raw((BitcurexMarketDataServiceRaw)marketDataService, pair.counter.getCurrencyCode());
    }

    private static void generic(MarketDataService marketDataService, CurrencyPair pair) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(pair, new Object[0]);
        System.out.println("Current Order Book size for BTC / " + pair.counter.getCurrencyCode() + ": " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(BitcurexMarketDataServiceRaw marketDataService, String counterSymbol) throws IOException {
        BitcurexDepth bitcurexDepth = marketDataService.getBitcurexOrderBook(counterSymbol);
        System.out.println("Current Order Book size for BTC / " + counterSymbol + ": " + (bitcurexDepth.getAsks().size() + bitcurexDepth.getBids().size()));
        System.out.println("First Ask: " + ((BigDecimal[])bitcurexDepth.getAsks().get(0))[0].toString());
        System.out.println("First Bid: " + ((BigDecimal[])bitcurexDepth.getBids().get(0))[0].toString());
        System.out.println(bitcurexDepth.toString());
    }
}

